/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.wxpay.v3.model.weixin;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.WxpayResponse;
import com.mini.framework.util.asserts.AssertUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class AccountResultFileResponse
extends WxpayResponse {
    @SerializedName(value="download_url")
    private String resourceUrl;
    @SerializedName(value="hash_value")
    private String fileHashValue;
    @SerializedName(value="hash_type")
    private String fileHashType;

    public static Optional<String> findUrlParamByName(String url, String name) {
        return Optional.ofNullable(AccountResultFileResponse.findUrlParams(url).get(name));
    }

    public static Map<String, String> findUrlParams(String url) {
        String queries = StringUtils.substringAfter((String)url, (String)"?");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        Stream.of(queries.split("&")).forEach(item -> {
            String[] nameValue = item.split("=");
            if (nameValue.length > 1) {
                params.put(nameValue[0], nameValue[1]);
            }
        });
        return params;
    }

    public Optional<String> queryTokenOfResourceUrl() {
        return AccountResultFileResponse.findUrlParamByName(this.resourceUrl, "token");
    }

    public Optional<String> queryTarTypeOfResourceUrl() {
        return AccountResultFileResponse.findUrlParamByName(this.resourceUrl, "tartype");
    }

    public String getPathOfResourceUrl() {
        return StringUtils.substringBefore((String)this.getFullOfResourceUrl(), (String)"?");
    }

    public String getFullOfResourceUrl() {
        AssertUtil.assertMethodRequire((Object)this.resourceUrl, (String)"resourceUrl");
        String temp = this.resourceUrl;
        temp = temp.replaceFirst("/", "");
        temp = temp.replaceFirst("/", "");
        int offset = temp.indexOf("/");
        return temp.substring(offset);
    }

    public String getResourceUrl() {
        return this.resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    public String getFileHashValue() {
        return this.fileHashValue;
    }

    public void setFileHashValue(String fileHashValue) {
        this.fileHashValue = fileHashValue;
    }

    public String getFileHashType() {
        return this.fileHashType;
    }

    public void setFileHashType(String fileHashType) {
        this.fileHashType = fileHashType;
    }
}

