package com.mini.framework.util.cache;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * @author 内存字节缓存器
 *
 */
public  interface ByteArrayMemoryCachable<K> {

	Logger logger = LogManager.getLogger(ByteArrayMemoryCachable.class);

	public ConcurrentMap<String, byte[]> caches = new ConcurrentHashMap<>();
	
	default public byte[] copyCache(K key){
		AssertUtil.haveParams(key, "缓存key不能为空");
		byte[] cache = caches.get(key);
		if(cache==null){
			cache = cache(key);
			caches.put(String.valueOf(key), cache);
		}
		return Arrays.copyOf(cache, cache.length);
	}

	public byte[] cache(K key);

	
	
}
