package com.mini.framework.util.cache.prepare.merge.data;

import java.util.Optional;

/**
 * 工作延迟锁
 * @author jayheo
 */
public interface WorkDelayLock {

    /**
     * 尝试去上锁
     * @param workerName 自己的名字
     * @param key 锁的key
     * @return Optional<String> empty代表上锁成功，否则上锁失败反回当前上锁的名字
     * */
    Optional<String> triesLock(String key,String workerName);


    /**
     * 释放锁，也就是解锁
     * @param key 锁的key
     * */
    void releaseLock(String key);


}
