package com.mini.framework.util.export;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 表格的一个列的列声明
 * 用于导出数据到表格上的时候。
 *
 * @author jayheo
 *
 */
@Target({ElementType.METHOD,ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ExcelColumnDeclares {

	/**
	 * 这个声明的名字
	 * @return
	 */
	String name();
	
	/**
	 * 列表的起始路径
	 * @return
	 */
	String listRootPath();
	
	/**
	 * 某一列的声明
	 * @return
	 */
	ExcelColumnDeclare[] value();
}
