package com.mini.framework.util.export.protocol.branch;

import com.mini.framework.core.code.standard.style01.flag.define.CodeStandardDefineFind;

import java.util.Arrays;
import java.util.Optional;

/**
 * 分支替换
 * @author jayheo
 */
public @interface NameSwitchCase {

    /**
     * 发现某个情况
     * @return
     */
    String[] whenCase();

    /**
     * 返回结果
     * @return
     */
    String result();


    /**
     * 一个静态的支持类
     */
    static interface Support{

        /**
         * 是不是匹配case
         * @param nameSwitchCase
         * @param origin
         * @return
         */
        static boolean matchCase(NameSwitchCase nameSwitchCase, String origin){

            if(origin==null){
                return nameSwitchCase.whenCase().length==0;
            }else{
                return Arrays.asList(nameSwitchCase.whenCase()).contains(origin);
            }

        }

        /**
         * 应用case
         * @param nameSwitchCase
         * @param origin
         * @return
         */
        static String applyCase(NameSwitchCase nameSwitchCase, String origin){
            return findCaseResult(nameSwitchCase, origin).orElse(origin);
        }


        /**
         * 查找匹配的值。如果不匹配返回 empty
         * @param nameSwitchCase
         * @return
         */
        @CodeStandardDefineFind
        static Optional<String> findCaseResult(NameSwitchCase nameSwitchCase, String origin){
            return matchCase(nameSwitchCase, origin)?Optional.of(nameSwitchCase.result()):Optional.empty();
        }


    }

}
