package com.mini.framework.util.file;

import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.core.exception.HandleNotFoundException;
import com.mini.framework.core.exception.HandleReflectException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.core.io.UrlResource;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;
import java.util.stream.Collectors;


/**
 * excel工具类
 * @author jayheo
 *
 */
public class ExcelUtil {
	
	public static byte[] writeToByte(LinkedHashMap<String,String> titles, List<Map<String, String>> datas){
		return writeToByte(titles, datas, "sheet1");
	}
	
	/**
	 * 向excel里写入数据
	 * @param titles
	 * @param datas
	 * @param name
	 * @return
	 */
	public static byte[] writeToByte(LinkedHashMap<String,String> titles, List<Map<String, String>> datas,String name){
		HSSFWorkbook hssfWorkbook = new HSSFWorkbook();
		HSSFSheet sheet = hssfWorkbook.createSheet(name);
		HSSFRow titleRow = sheet.createRow(0);
		List<Entry<String, String>> titleList = new ArrayList<>(titles.entrySet());
		
		for (int i = 0; i < titleList.size(); i++) {
			String value = titleList.get(i).getValue();
			HSSFCell cell = titleRow.createCell(i);
			cell.setCellValue(value);
		}
		
		for (int i = 0; i < datas.size(); i++) {
			HSSFRow row = sheet.createRow(i + 1);
			Map<String, String> data = datas.get(i);
			for (int j = 0; j < titleList.size(); j++) {
				String key = titleList.get(j).getKey();
				String value = data.get(key);
				HSSFCell cell = row.createCell(j);
				cell.setCellValue(value);
			}
		}
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		try{
			hssfWorkbook.write(baos);
			return baos.toByteArray();
		}catch(IOException e){
			throw new HandleIOException(e,"在写出excel时出错");
		}finally{
			IOUtils.closeQuietly(hssfWorkbook);
		}
		
	}

	/**
	 * 不再使用了，请换成。
	 * @see #readFromPathIncludeHead(String)
	 * @see #readFromPathUseHead(String)
	 * @param filepath 数据文件路径
	 * @param header 是不是要拿头部做
	 * @return 数据
	 */
	@Deprecated
	public static List<Map<String, String>> read(String filepath, boolean header) {
		try {
			return read(new FileInputStream(filepath),header);
		} catch (FileNotFoundException e) {
			throw new HandleNotFoundException(e,"读文件:[%s]流时出错",filepath);
		}
	}


	/**
	 * 不再使用了，请换成。
	 * @see #read(InputStream)
	 * @see #readUseHead(InputStream)
	 * @param inputStream 数据流
	 * @param header 是不是要拿头部做
	 * @return 数据
	 */
	@Deprecated
	public static List<Map<String, String>> read(InputStream inputStream, boolean header) {
		if(header){
			return readUseHead(inputStream).orElse(null);
		}else{
			return readIncludeHead(inputStream);
		}
	}


	/**
	 * 读取为List map
	 * 包含第一行。
	 * @param resourceUrl 资源url
	 * @return  数据
	 */
	public static List<Map<String,String>> readFromUrlIncludeHead(String resourceUrl){
		InputStream inputStream = readInputStreamFromUrl(resourceUrl);
		return read(inputStream);
	}


	/**
	 * 读取为List map
	 * 包含第一行。
	 * @param path 文件路径
	 * @return  数据
	 */
	public static List<Map<String,String>> readFromPathIncludeHead(String path){
		InputStream inputStream = readInputStreamFromPath(path);
		return read(inputStream);
	}


	/**
	 * 读取为List map
	 * 以第一行为头部
	 * @param resourceUrl 资源url
	 * @return  数据
	 */
	public static Optional<List<Map<String,String>>> readFromUrlUseHead(String resourceUrl){
		InputStream inputStream = readInputStreamFromUrl(resourceUrl);
		return readUseHead(inputStream);
	}


	/**
	 * 读取为List map
	 * 以第一行为头部
	 * @param path 文件路径
	 * @return  数据
	 */
	public static Optional<List<Map<String,String>>> readFromPathUseHead(String path){
		InputStream inputStream = readInputStreamFromPath(path);
		return readUseHead(inputStream);
	}

	/**
	 * 读取为List map 有头部的。
	 * @param inputStream 资源流
	 * @return  数据可能为空
	 */
	public static Optional<List<Map<String,String>>> readUseHead(InputStream inputStream){
		List<Map<String, String>> list = read(inputStream);
		return list.stream().findFirst().map(head->{
			List<Map<String, String>> result = new ArrayList<>();
			list.stream().skip(1)
			//head 不算到数据中去。
			.forEach(oldData->{
				Map<String, String> newData = new LinkedHashMap<>();
				result.add(newData);
				for (Entry<String, String> entry : oldData.entrySet()) {
					newData.put(head.get(entry.getKey()), entry.getValue());
				}
			});
			return result;
		});
	}

	/**
	 * 读取为List map 有头部的。
	 * @param inputStream 源数据流
	 * @return  数据
	 */
	public static List<Map<String,String>> readIncludeHead(InputStream inputStream){
		return read(inputStream);
	}

	/**
	 * 读取为List map
	 * @param resourceUrl 源数据流
	 * @return  数据
	 */
	private static InputStream readInputStreamFromUrl(String resourceUrl){
        UrlResource urlResource = null;
        try {
            urlResource = new UrlResource(new URL(resourceUrl));
        	return urlResource.getInputStream();
        } catch (MalformedURLException e) {
            throw new HandleIOException(e,"url:[%s]格式错误", resourceUrl);
        }catch (IOException e){
			throw new HandleIOException(e,"在写出excel时出错");
		}
	}


	private static InputStream readInputStreamFromPath(String filepath){
        try {
            return new FileInputStream(filepath);
        } catch (FileNotFoundException e) {
			throw new HandleNotFoundException(e,"读文件:[%s]流时出错",filepath);
        }
    }


	public static List<Map<String, String>> read(String filepath) {
		try {
			return read(new FileInputStream(new File(filepath)));
		} catch (FileNotFoundException e) {
			throw new HandleNotFoundException(e,"读文件:[%s]流时出错",filepath);
		}
	}
	
	public static List<Map<String, String>> read(InputStream inputStream) {
		List<List<String>> rows = readStringRows(inputStream);
		return rows.stream().map(row->{
			Map<String, String> map= new HashMap<>();
			for (int index = 0; index < row.size(); index++) {
				map.put(String.valueOf(index), row.get(index));
			}
			return map;
		}).collect(Collectors.toList());
	}


	/**
	 * 读取为List string
	 * @param inputStream 输入 流
	 * @return 列表
	 */
	public static List<List<String>> readStringRows(InputStream inputStream) {
		try (HSSFWorkbook hssfWorkbook = new HSSFWorkbook(inputStream)){
			HSSFSheet sheet = hssfWorkbook.getSheetAt(0);
			List<List<String>> list = new ArrayList<>();
            for (Row row : sheet) {
				List<String> data = new ArrayList<>();
                list.add(data);
                for (Cell cell : row) {
                    data.add(cell.toString());
                }
            }
			return list;
		} catch (IOException e) {
			throw new HandleIOException(e,"读文件流时出错");
		} finally {
			IOUtils.closeQuietly(inputStream);
		}
	}
	
	/**
	 * 从excel文件中把结果读到list bean中<br>
	 * 这里要求第一行和bean的属性一致<br>
	 * @param filepath
	 * @param clazz
	 * @return
	 */
	public static <E> List<E> read(String filepath, Class<E> clazz) {
		try {
			return read(new FileInputStream(new File(filepath)), clazz);
		} catch (FileNotFoundException e) {
			throw new HandleNotFoundException(e,"读文件:[%s]流时出错",filepath);
		}
	}
	
	
	/**
	 * 从excel文件中把结果读到list bean中<br>
	 * 这里要求第一行和bean的属性一致<br>
	 * @param is
	 * @param clazz
	 * @return
	 */
	public static <E> List<E> read(InputStream is, Class<E> clazz) {
		E obj = null;
		List<Map<String, String>> list = read(is, true);
		List<E> result = new ArrayList<E>();
		for (Map<String, String> map : list) {
			try {
				obj = clazz.newInstance();
				populate(obj, map);
				result.add(obj);
			} catch (InstantiationException | IllegalAccessException e) {
				throw new HandleReflectException(e,"实例化bean时出错");
			}
		}
		return result;
	}

	/**
	 * 把map里的值放到obj中
	 * */
	private static void populate(Object obj, Map<String, ?> map) {
		try {
			BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
			PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
			for (PropertyDescriptor property : propertyDescriptors) {
				String key = property.getName();
				if (map.containsKey(key)) {
					Object value = map.get(key);
					// 得到property对应的setter方法
					Method setter = property.getWriteMethod();
					setter.invoke(obj, value);
				}
			}
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | IntrospectionException e) {
			throw new HandleReflectException(e,"尝试把map转化成bean失败");
		}

	}
}

