package com.mini.framework.util.http.linked;

import java.util.Date;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Pattern;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class HeaderInterceptor {
	
	private Logger logger = Logger.getLogger(HeaderInterceptor.class.getName());
	
	public static String tokenKey = "x-mn-token";
	public static String siteKey = "x-mn-site";
	public static String clientIdKey = "x-client-id";
	public static String changeTokenKey = "x-change-token";
	public static String clearTokenKey = "x-clear-token";

	/**<pre>
前端需要在req拦截里做得事情
1，x-mn-site 传商家id，需要检查 “undefined” undefined和””反正非数字不要传要清除。
2，x-mn-token传商户的token
3，x-client-feature 传设备的类型。
4，x-client-id 生成一个4+4+6+3+10位的数字长期储存在localStorage里面。传给服务器，用于用户跟踪。
5，x-client-mark 调试使用的，方便查问题，传了的话，后台日志中会有这个信息。。
</pre>
	 * @param localStorage
	 * @param headers
	 */
	public boolean beforeRequest(boolean requireAuth, Map<String, String> localStorage, Map<String, String> headers,Supplier<String> tokenSupplier) {
		String token = localStorage.get(tokenKey);
		if(requireAuth && token != null){
			token = tokenSupplier.get();
			localStorage.putIfAbsent(tokenKey, token);
		}
		
		headers.putIfAbsent(tokenKey, token);
		
		String site = localStorage.get(siteKey);
		headers.putIfAbsent(siteKey, site);
		
		String clientId = localStorage.get(clientIdKey);
		clientId = sureRightClientId(clientId);
		headers.put(clientIdKey, clientId);
		return true;
	}

	/**
	 * <pre>
前端需要在resp拦截里做得事情
1，出现x-change-token用新token替换旧token
2，出现x-curr-site检查本地的，如果本地没有替换，如果不一样报错。
3，x-req-id其实是一个重要的信息，可和时间一起打到控制台。
4，x-clear-token 为true 是服务要求把token清除，直接清楚就行了。
</pre>
	 * @param localStorage
	 * @param requestHeaders
	 * @param responseHeaders
	 */
	public boolean afterRequest(Map<String, String> localStorage, Map<String, String> requestHeaders,Map<String, String> responseHeaders) {
		if(responseHeaders.get(clearTokenKey)!=null){
			localStorage.remove(tokenKey);
		}
		
		if(responseHeaders.get(changeTokenKey)!=null){
			localStorage.put(tokenKey, responseHeaders.get(changeTokenKey));
		}
		return true;
	}
	
	
	/**
	 * 确认正确的clientid
	 * @param clientId
	 * @return
	 */
	public String sureRightClientId(String clientId){
		if(clientId!=null && Pattern.matches("//d{27}", clientId)){
			return clientId;
		}else{
			return DateFormatUtils.format(new Date(), "yyyyMMDDHHmmssSSS") + RandomStringUtils.randomNumeric(10);
		}
	}

}
