package com.mini.framework.util.http.linked;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * 响应处理器
 * 1，统一处理服务端要做的事，不能终端异常。status+headers
 * 2，解析看有没有错误，如果有错误终端线程。status+body.
 * 3，解析出结果映射到对应的bean    body.
 * @author jayheo
 *
 * @param <T>
 */
public class HttpResponseHandler<T>{

	private static Logger logger = Logger.getLogger(HttpResponseHandler.class.getName());
	
	/**
	 * 响应过滤器
	 * 统一处理服务端要做的事，不能终端异常
	 */
	private Consumer<HttpResponse> responseFilter;
	
	/**
	 * 响应拦截器
	 * 解析看有没有错误，如果有错误终端线程。
	 */
	private Function<HttpResponse,Boolean> responseIntercept;
	
	/**
	 * 响应解析器
	 * 解析出结果映射到对应的bean
	 */
	private Function<HttpResponse,T> responseResolver;
	
	/**
	 * 绑定过滤器
	 * @param responseFilter
	 * @return
	 */
	public HttpResponseHandler<T> bindFilter(Consumer<HttpResponse> responseFilter){
		this.responseFilter = responseFilter;
		return this;
	}

	/**
	 * 绑定拦截器
	 * @param responseIntercept
	 * @return
	 */
	public HttpResponseHandler<T> bindIntercept(Function<HttpResponse,Boolean> responseIntercept){
		this.responseIntercept = responseIntercept;
		return this;
	}
	
	/**
	 * 绑定解析器
	 * @param responseResolver
	 * @return
	 */
	public HttpResponseHandler<T> bindResolver(Function<HttpResponse,T> responseResolver){
		this.responseResolver = responseResolver;
		return this;
	}
	
	

	private String charset = "utf-8";
	
	private HttpResponseHandler() {
		initDefault();
	}
	
	private void initDefault() {
		bindIntercept(resp->{
			int status = resp.getStatus();
			switch (status/100) {
			case 2:
				return true;
			case 3:
				return false;
			case 4:
				return false;
			case 5:
				return false;
			default :
				return false;
			}
		});
	}
	
	
	
	
	public static HttpResponseHandler<String> createString(){
		return create(String.class).bindResolver(resp->resp.getBody()+"");
	}
	
	public static <T> HttpResponseHandler<T> create(Class<T> clazz){
		return new HttpResponseHandler<>();
	}
	
	public void validate(){
		
	}
	

	public T hande(HttpResponse response) {
		validate();
		try{
			responseFilter.accept(response);
		}catch(Throwable e){
			logger.log(Level.SEVERE,"过程器出来异常忽略", e);
		}
		Boolean right = responseIntercept.apply(response);
		if(right){
			return responseResolver.apply(response);
		}else{
			return null;
		}
	}
	
}
