package com.mini.framework.util.mq;

import java.util.Date;
import java.util.concurrent.TimeUnit;

import com.mini.framework.util.bean.BeanSerializable;

/**
 * 可以延迟的事件
 * 
 * @author jayheo
 *
 */
public interface MqDelayMessage extends MqMessage,BeanSerializable {

	void setDelayDate(Date delay);

	Date getDelayDate();

	/**
	 * 设置延时
	 * 
	 * @param time
	 * @param timeUnit
	 * @return 
	 */
	default MqDelayMessage delay(int time, TimeUnit timeUnit) {
		long timeDelay = timeUnit.toMillis(time);
		Date delay = new Date(System.currentTimeMillis() + timeDelay);
		setDelayDate(delay);
		return this;
	}
	
	default MqDelayMessage clearDelay() {
		setDelayDate(null);
		return this;
	}
	
}
