package com.mini.framework.util.require.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.bean.VarUtil;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.string.RegexUtil;
import com.mini.framework.util.string.bean.SplitItemPoint;
import com.mini.framework.core.exception.standard.UnsupportedException;


/**
 * 依赖建造者
 * @author jayheo
 *
 */
public class MessageBuilder {

	private static Logger logger = LogManager.getLogger(MessageBuilder.class);

	private List<Append> appends = new ArrayList<>();
	
	private static SwitchQueryer switchQueryer;
	
	private static ConcurrentHashMap<String, ParamFieldPair> allFieldPairs;
	

	public static void init(SwitchQueryer switchQueryer,FieldFinderTraversal fieldFinderTraversal){
		AssertUtil.assertMethodRequire(switchQueryer, "switchQueryer");
		AssertUtil.assertMethodRequire(fieldFinderTraversal, "fieldFinderTraversal");
		if(!isInit()){
			synchronized (MessageBuilder.class) {
				if(!isInit()){
					storeToStatic(switchQueryer, fieldFinderTraversal);
				}else{
					logger.error("MessageBuilder只需要被初始化一次");
				}
			}
		}
	}
	
	
	public static boolean isInit(){
		return MessageBuilder.switchQueryer !=null;
	}
	
	private MessageBuilder(){}
	
	public static MessageBuilder create(){
		if(isInit()){
			return new MessageBuilder();
		}else{
			throw new UnsupportedException("MessageBuilder还没有被成功初始化");
		}
	}
	
	/**
	 * 
	 * 初始化
	 * @param switchQueryer
	 * @return
	 */
	private static void storeToStatic(SwitchQueryer switchQueryer,FieldFinderTraversal fieldFinderTraversal){
		//TODO 这里是不是被初始化多次了
		MessageBuilder.switchQueryer = switchQueryer;
		allFieldPairs= new ConcurrentHashMap<>();
		ArrayList<ParamFieldPair> fieldPairs = new ArrayList<>(fieldFinderTraversal.traversal());
		fieldPairs.forEach(fieldPair->{
			String expression = fieldPair.getExpression();
			AssertUtil.assertSupport(expression!=null,"fieldFinderTraversal出现了expression为空的数据");
			AssertUtil.assertSupport(allFieldPairs.get(expression)==null,"fieldFinderTraversal出现了多个expression:[%s]",expression);
			allFieldPairs.put(expression, fieldPair);
		});
	}
	
	/**
	 * 返回建造的值
	 * @return
	 */
	public String build(){
		List<String> appendStrings = appends.stream().map(append->{
			Object[] args = append.filedHolds.stream().map(filedHold->{
				Queryer queryer = getQuery(switchQueryer,filedHold);
				return filedHold.execute(queryer);
			}).toArray();
			//TODO 这里要把文档中出现的%处理到才用String.format
			return String.format(append.string, args );
			
		}).collect(Collectors.toList());
		
		return String.join("", appendStrings);
	}
	
	/**
	 * 添加增量
	 * @param string
	 * @param delays
	 * @return
	 */
	public MessageBuilder append(String string, ParamFieldPair ... delays) {
		Stream.of(delays).forEach(delay->{
			AssertUtil.assertSupport(delay!=null, "不允许写空参数");
			getQuery(switchQueryer,delay);
		});
		appends.add(new Append(string, Arrays.asList(delays)));
		return this;
	}
	

	public MessageBuilder appendString(String template,Map<String, Object> params){
		return appendString(template, RequireParams.create(params));
	}
	
	/**
	 * 匹配字符串计算
	 * @param template
	 * @param params
	 * @return
	 */
	public MessageBuilder appendString(String template,RequireParams params){
		logger.debug(Event5WBuilder.event(1, "appendString").what("尝试创建消息").how("使用参数 template:%s,params:%s",template, params));
		//TODO 这里不允许temp中出现%s，如果有要先换成其它的词，等生成字符串后再变回来
		//允许params中有ParamFieldPair
		//1 尝试解析出 ${user.name(1)} ->   user.name   1
		String funexp = RegexUtil.regexCharsAsNormal("${[1-9a-zA-Z.]*([1-9a-zA-Z.]*)}","${}()");
		SplitItemPoint sip = RegexUtil.getSplitItemPoint(funexp, template);
		List<ParamFieldPair> delays = sip.getPoints().stream().map(point->{
			String[] matchs = RegexUtil.getMatch("\\$\\{(.*)\\((.*)\\)\\}", point, 1,2);
			String method = matchs[0];
			String paramStr = matchs[1];
			//TODO 这里要注意，保证入参的格式是正确的
			Object param = VarUtil.firstNotNull( params.get(paramStr),paramStr);
			FieldFinder fieldFinder = getFieldFinder(method);
			ParamFieldPair pair = new ParamFieldPair(method, ()-> param, fieldFinder);
			return pair;
		}).collect(Collectors.toList());
		
		sip.setAllPoint("%s");
		String temp = sip.assem();
		
		//2 尝试解析出 ${key}  key在params正好是  ParamFieldPair 类型的数据
		for (Entry<String, Object> entry : params.getValues().entrySet()) {
			if(entry.getValue() instanceof ParamFieldPair){
				String paramKey = entry.getKey();
				String explan = String.format("${%s}",paramKey);//${userNick}
				while(temp.contains(explan)){
					//这里出现一点点误差没有关系
					String beforeStr = StringUtils.substringBefore(temp, paramKey);
					int scount = StringUtils.countMatches(beforeStr, "%s");
					//准确的把%s放到对应的位置
					delays.add(scount,(ParamFieldPair) entry.getValue());
					temp = StringUtils.replaceOnce(temp ,explan,"%s" );
				}
			}
		}
		//3 尝试解析出${key} 与key在params正好是string supplier 等数据
		temp = RegexUtil.applyPlaceholder(temp, params.getValues());
		return append(temp, delays.toArray(new ParamFieldPair[]{})); 
	}
	
	
	private Queryer getQuery(SwitchQueryer switchQueryer, ParamFieldPair delay) {
		FieldFinder fieldFinder = delay.getFieldFinder();
		AssertUtil.assertSupport(switchQueryer!=null, "没有%s对应的查询器", fieldFinder);
		Queryer queryer = switchQueryer.apply(fieldFinder);
		AssertUtil.assertSupport(queryer!=null, "没有%s对应的查询器", fieldFinder);
		return queryer;
	}
	
	private FieldFinder  getFieldFinder(String expression){
		AssertUtil.assertMethodRequire(expression, "expression");
		AssertUtil.assertSupport(allFieldPairs!=null, "在使用字符串模板功能在create的时候必须添加模板映射fieldFinderTraversal");
		ParamFieldPair pair = allFieldPairs.get(expression);
		AssertUtil.assertSupport(pair!=null, "找不到:[%s]对应的延迟方法", expression);
		return pair.getFieldFinder();
	}
	
	

	public static class Append {
		private String string;
		private List<ParamFieldPair> filedHolds;
		
		public Append(String string, List<ParamFieldPair> filedHolds) {
			super();
			this.string = string;
			this.filedHolds = filedHolds;
		}
	}
	
}
