package com.mini.framework.util.score;

import java.util.Date;

public class NewtonCoolingUtil {

	/**
	 * 1%的收敛周期
	 */
	private int astringeCycle;

	/**
	 * 收敛时间单元，单位毫秒
	 */
	private int astringeTimeUnit;

	public int getAstringeCycle() {
		return astringeCycle;
	}

	public void setAstringeCycle(int astringeCycle) {
		this.astringeCycle = astringeCycle;
	}

	public int getAstringeTimeUnit() {
		return astringeTimeUnit;
	}

	public void setAstringeTimeUnit(int astringeTimeUnit) {
		this.astringeTimeUnit = astringeTimeUnit;
	}

	public NewtonCoolingUtil(int astringeCycle, int astringeTimeUnit) {
		super();
		this.astringeCycle = astringeCycle;
		this.astringeTimeUnit = astringeTimeUnit;
	}
	
	/**
	 * 按秒冷却
	 * @param astringeCycle
	 * @return
	 */
	public static NewtonCoolingUtil createSeconds(int astringeCycle) {
		return create(astringeCycle,1000);
	}
	
	/**
	 * 按分钟冷却
	 * @param astringeCycle
	 * @return
	 */
	public static NewtonCoolingUtil createMinute(int astringeCycle) {
		return create(astringeCycle,1000 * 60);
	}

	/**
	 * 创建一个冷却的工具类
	 * @param astringeCycle 冷却到原来1%的周期，如果是10000表示10000个astringeTimeUnit(冷却时间单元)后变到1%
	 * @param astringeTimeUnit 冷却时间单元一般一说是分钟也可以是秒钟
	 * @return
	 */
	public static NewtonCoolingUtil create(int astringeCycle, int astringeTimeUnit) {
		return new NewtonCoolingUtil(astringeTimeUnit, astringeTimeUnit);
	}
	
	/**
	 * 使用牛顿冷却法算出冷却后的分数乘积
	 * 也就是看这里一冷却应该乘以多少，比如说是0.4，就是冷却到原来的40%
	 * @param oldDate 冷却前的日期
	 * @param newDate 冷却后的日期
	 * @return
	 */
	public double coolingScoreIncrement(Date oldDate,Date newDate){
		long times = (newDate.getTime() - oldDate.getTime())/astringeTimeUnit;
		return Math.pow(0.01, 1.0*times/astringeCycle);
	}
	/**
	 * 使用牛顿冷却法算出冷却后的分数
	 * @param oldDate 冷却前的日期
	 * @param newDate 冷却后的日期
	 * @param oldScore 冷却前的分数
	 * @return
	 */
	public double coolingNextScore(Date oldDate,Date newDate,double oldScore){
		double newScore = oldScore * coolingScoreIncrement(oldDate, newDate);
		return newScore;
	}

}
