package com.mini.framework.util.string.gson.format;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * 函数命令
 * @author jayheo
 *
 */
public class CommandParams {

	public final static String commandArgsSplit = ",";
	public final static String commandExplainSplitRegex = "\\||/";

	/**
	 * 命令的名字。
	 */
	private String name;

	/**
	 * 命令的参数序列
	 */
	private String[] args;

	/**
	 * 命令行。
	 */
	private String line;


	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String[] getArgs() {
		return args;
	}

	public void setArgs(String[] args) {
		this.args = args;
	}
	
	public String getLine() {
		return line;
	}

	public void setLine(String line) {
		this.line = line;
	}

	public CommandParams() {
		super();
	}


	/**
	 * 通过方法和参数创建
	 * @param name
	 * @param args
	 * @return
	 */
	public static CommandParams createFromFunctionParams(String name, String... args) {
		return new CommandParams(name,args,String.format("%s,%s",name,String.join(commandArgsSplit,args)));
	}

	public CommandParams(String name, String[] args,String line) {
		super();
		this.name = name;
		this.args = args;
		this.line = line;
	}


	public static List<CommandParamsDescribe> resolverExplainWithDescribe(String explain){
		return resolverExplain(explain).stream().map(CommandParamsDescribe::createFromCommand).collect(Collectors.toList());
	}


	public static List<CommandParams> resolverExplain(String explain){
		List<CommandParams> commandParamsList = new ArrayList<>();
		String[] commandSteps = explain.split(commandExplainSplitRegex);
		for (String commandStep : commandSteps) {
			String[] commands = commandStep.split(commandArgsSplit);
			String function = commands[0];
			String[] args = ArrayUtils.subarray(commands, 1, commands.length);
			commandParamsList.add(new CommandParams(function, args,commandStep));
		}
		return commandParamsList;
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

}
