package com.mini.framework.util.string.gson.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 表达式别名的命令参数。
 * @author jayheo
 */
public class ExplainAliasCommandParams {

    /**
     * 别名
     */
    private String alias;

    /**
     * 表达式
     */
    private String explain;


    /**
     * 对应的命令
     */
    private List<CommandParams> commands;

    /**
     * 对应的命令以及描述
     */
    private List<CommandParamsDescribe> commandDescribes;

    public static List<ExplainAliasCommandParams> createFromAliasExplainMapper(Map<String,String> aliasExplainMapper){
        List<ExplainAliasCommandParams> list = new ArrayList<>();
        aliasExplainMapper.forEach((alias,explain)->{
            list.add(createFromAliasExplain(alias,explain));
        });
        return list;
    }

    public static ExplainAliasCommandParams createFromAliasExplain(String alias, String explain){
        ExplainAliasCommandParams instance = new ExplainAliasCommandParams();
        instance.alias = alias;
        instance.explain = explain;
        instance.commands = CommandParams.resolverExplain(explain);
        instance.commandDescribes = instance.commands.stream().map(CommandParamsDescribe::createFromCommand).collect(Collectors.toList());
        return instance;
    }


    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getExplain() {
        return explain;
    }

    public void setExplain(String explain) {
        this.explain = explain;
    }

    public List<CommandParams> getCommands() {
        return commands;
    }

    public void setCommands(List<CommandParams> commands) {
        this.commands = commands;
    }

    public List<CommandParamsDescribe> getCommandDescribes() {
        return commandDescribes;
    }

    public void setCommandDescribes(List<CommandParamsDescribe> commandDescribes) {
        this.commandDescribes = commandDescribes;
    }
}
