package com.mini.framework.util.thread;

import java.util.Optional;

/**
 * obj存到线程中
 * 
 * @author jayheo
 *
 */
public interface ObjectThreadCachable<O> {
	/**
	 * 存obj到线程中
	 * @param obj
	 */
	void set(O obj);

	/**
	 * 存线程中取obj
	 * @return
	 */
	O get();


	/**
	 * 查询obj
	 * @return
	 */
	default Optional<O> query(){
		return Optional.ofNullable(get());
	}
	
	
	/**
	 * 线程开始
	 * 要求在线程run后必须线使用这个方法
	 * TODO 后面想一点办法实现这一点
	 */
	void begin();


	/**
	 * 清除当前的内容
	 * */
	default void clear(){
		set(null);
	}

}
