package com.mini.framework.util.thread;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <pre>
 * 通过aop自动注入运维用的商家id到线程里
 * 这个商家id一般会来源于配置 
 * 主要用于一些请求中不带商家id却又需要商家id的线程，比如系统启动
 * 这个功能必须配合  AsyncThreadMsgHandler使用
 * </pre>
 * @see AsyncThreadMsgHandler
 * @author jayheo
 *
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ThreadAutoFollowMsg {

}
