/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.bean;

import com.mini.framework.util.bean.WeightBean;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang.math.RandomUtils;

public class WeightRandomUtil {
    public static <B extends WeightBean, R> Optional<R> nextBean(Collection<B> beans, Function<B, R> fieldGetter) {
        return WeightRandomUtil.nextBean(beans).map(fieldGetter);
    }

    public static <B extends WeightBean> Optional<B> nextBean(Collection<B> beans) {
        double sum = WeightRandomUtil.sumWeight(beans);
        double randomValue = RandomUtils.nextDouble() * sum;
        WeightBean scanBean = null;
        double accumulateValue = 0.0;
        for (WeightBean bean : beans) {
            if ((accumulateValue += bean.showWeight()) > randomValue) {
                return Optional.of(bean);
            }
            scanBean = bean;
        }
        return Optional.ofNullable(scanBean);
    }

    public static <B extends WeightBean> double sumWeight(Collection<B> beans) {
        double sum = beans.stream().mapToDouble(WeightBean::showWeight).sum();
        return sum;
    }
}

