/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.date;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateUtil;
import com.mini.framework.util.date.TimeSectionType;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public class TimeSection {
    private TimeSectionType timeUnit;
    private Date sectionPoint;

    public TimeSection(TimeSectionType timeUnit, Date sectionPoint) {
        this.timeUnit = timeUnit;
        this.sectionPoint = sectionPoint;
        this.validate();
    }

    public TimeSectionType getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeSectionType timeUnit) {
        this.timeUnit = timeUnit;
    }

    public Date getSectionPoint() {
        return this.sectionPoint;
    }

    public void setSectionPoint(Date sectionPoint) {
        this.sectionPoint = sectionPoint;
    }

    public void validate() {
        AssertUtil.assertNoBadReq(this.timeUnit != null, Status.BadReq.illParam, "\u4e0d\u80fd\u6ca1\u6709\u65f6\u95f4\u5355\u5143timeUnit", new Object[0]);
        AssertUtil.assertNoBadReq(this.sectionPoint != null, Status.BadReq.illParam, "\u4e0d\u80fd\u6ca1\u6709\u65f6\u95f4\u8d77\u70b9", new Object[0]);
        boolean vali = DateUtil.isDateUnitPoint(this.timeUnit, this.sectionPoint);
        AssertUtil.assertNoBadReq(vali, Status.BadReq.illParam, "\u65f6\u95f4:[%s]\u5fc5\u987b\u4e3a%s\u7684\u8d77\u70b9", this.sectionPoint, this.timeUnit);
    }

    public static TimeSection createTimeSection(Date date, TimeSectionType timeSectionType) {
        Date sectionPoint = DateUtil.getCleanedDateUnit(timeSectionType, date);
        return new TimeSection(timeSectionType, sectionPoint);
    }

    public Date countEndDatePoint() {
        this.validate();
        if (TimeSectionType.all.equals(this.timeUnit)) {
            return DateUtils.addYears((Date)this.sectionPoint, (int)1000);
        }
        return DateUtil.addTimeUnit(this.timeUnit, this.sectionPoint, 1);
    }
}

