/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.date.bean;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.bean.RelativeDateAliasScheme;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class RelativeDate {
    private Date referTargetDate;
    private Date actualDate;
    private Long intervalTime;
    private String intervalName;
    RelativeDateAliasScheme aliasScheme;

    public RelativeDate() {
    }

    public static RelativeDate countRelative(RelativeDateAliasScheme aliasScheme, Date referTargetDate, Date actualDate) {
        return new RelativeDate(aliasScheme, referTargetDate, actualDate);
    }

    public static List<RelativeDate> countRelatives(RelativeDateAliasScheme aliasScheme, Date referTargetDate, Stream<Date> actualDates) {
        return actualDates.map(actualDate -> RelativeDate.countRelative(aliasScheme, referTargetDate, actualDate)).collect(Collectors.toList());
    }

    public static <D> List<RelativeDate> countRelatives(RelativeDateAliasScheme aliasScheme, Date referTargetDate, List<D> actualDates, Function<D, Date> dateGetter) {
        return RelativeDate.countRelatives(aliasScheme, referTargetDate, actualDates.stream().map(dateGetter));
    }

    public static Map<RelativeDateAliasScheme, RelativeDate> countRelative(Date referTargetDate, Date actualDate, RelativeDateAliasScheme ... aliasSchemes) {
        HashMap<RelativeDateAliasScheme, RelativeDate> mapper = new HashMap<RelativeDateAliasScheme, RelativeDate>();
        for (RelativeDateAliasScheme aliasScheme : aliasSchemes) {
            mapper.put(aliasScheme, new RelativeDate(aliasScheme, referTargetDate, actualDate));
        }
        return mapper;
    }

    public static List<Map<RelativeDateAliasScheme, RelativeDate>> countRelatives(Date referTargetDate, Stream<Date> actualDates, RelativeDateAliasScheme ... aliasSchemes) {
        return actualDates.map(actualDate -> RelativeDate.countRelative(referTargetDate, actualDate, aliasSchemes)).collect(Collectors.toList());
    }

    public static <D> List<Map<RelativeDateAliasScheme, RelativeDate>> countRelatives(Date referTargetDate, List<D> actualDates, Function<D, Date> dateGetter, RelativeDateAliasScheme ... aliasSchemes) {
        return RelativeDate.countRelatives(referTargetDate, actualDates.stream().map(dateGetter), aliasSchemes);
    }

    public RelativeDate(RelativeDateAliasScheme aliasScheme, Date referTargetDate, Date actualDate) {
        AssertUtil.assertMethodRequire(actualDate, "actualDate");
        AssertUtil.assertMethodRequire(aliasScheme, "aliasScheme");
        AssertUtil.assertMethodRequire(referTargetDate, "referTargetDate");
        this.aliasScheme = aliasScheme;
        this.referTargetDate = referTargetDate;
        this.actualDate = actualDate;
        this.intervalTime = actualDate.getTime() - referTargetDate.getTime();
        this.intervalName = aliasScheme.countRelativeName(this.intervalTime);
    }

    public Date getReferTargetDate() {
        return this.referTargetDate;
    }

    public void setReferTargetDate(Date referTargetDate) {
        this.referTargetDate = referTargetDate;
    }

    public Date getActualDate() {
        return this.actualDate;
    }

    public void setActualDate(Date actualDate) {
        this.actualDate = actualDate;
    }

    public Long getIntervalTime() {
        return this.intervalTime;
    }

    public void setIntervalTime(Long intervalTime) {
        this.intervalTime = intervalTime;
    }

    public String getIntervalName() {
        return this.intervalName;
    }

    public void setIntervalName(String intervalName) {
        this.intervalName = intervalName;
    }

    public RelativeDateAliasScheme getAliasScheme() {
        return this.aliasScheme;
    }

    public void setAliasScheme(RelativeDateAliasScheme aliasScheme) {
        this.aliasScheme = aliasScheme;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

