/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.export.protocol.branch;

import com.mini.framework.core.code.standard.style01.flag.define.CodeStandardDefineFind;
import java.util.Optional;
import java.util.stream.Stream;

public @interface BooleanSwitchCase {
    public String trueResult();

    public String falseResult();

    public String nullResult() default "";

    public static interface Support {
        public static String applyBooleanCase(BooleanSwitchCase switchCase, Optional<Boolean> stateOptional) {
            return stateOptional.map(state -> state != false ? switchCase.trueResult() : switchCase.falseResult()).orElse(switchCase.nullResult());
        }

        public static String applyCase(BooleanSwitchCase switchCase, String origin) {
            return Support.findCaseResult(switchCase, origin).orElse(origin);
        }

        public static Optional<String> findCaseResult(BooleanSwitchCase switchCase, String origin) {
            String value = Support.applyBooleanCase(switchCase, Support.findMatchCaseBoolean(switchCase, origin));
            return Optional.ofNullable(value);
        }

        @CodeStandardDefineFind
        public static Optional<Boolean> findMatchCaseBoolean(BooleanSwitchCase switchCase, String origin) {
            return Stream.of("true", "false").filter(value -> origin != null).filter(value -> value.equals(origin)).map(Boolean::valueOf).findFirst();
        }
    }
}

