/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.function;

import com.mini.framework.util.asserts.AssertUtil;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class FinalUsefulBeanOptional<B> {
    private B beanNullable;

    private FinalUsefulBeanOptional(Optional<B> beanOptional) {
        AssertUtil.assertMethodRequire(beanOptional, "beanOptional");
        this.beanNullable = beanOptional.orElse(null);
    }

    private FinalUsefulBeanOptional(B beanNullable) {
        this(Optional.ofNullable(beanNullable));
    }

    public static <B> FinalUsefulBeanOptional<B> empty() {
        return new FinalUsefulBeanOptional(Optional.empty());
    }

    public static <B> FinalUsefulBeanOptional<B> ofNullable(B bean) {
        return new FinalUsefulBeanOptional<B>(bean);
    }

    public static <B> FinalUsefulBeanOptional<B> of(Optional<B> beanOptional) {
        return new FinalUsefulBeanOptional<Optional<B>>(beanOptional);
    }

    public static <B> FinalUsefulBeanOptional<B> of(B bean) {
        AssertUtil.assertMethodRequire(bean, "bean");
        return new FinalUsefulBeanOptional<B>(bean);
    }

    public Optional<B> showOptional() {
        return Optional.ofNullable(this.beanNullable);
    }

    public FinalUsefulBeanOptional<B> set(Optional<B> beanOptional) {
        beanOptional.ifPresent(this::set);
        return this;
    }

    public FinalUsefulBeanOptional<B> set(B bean) {
        AssertUtil.assertMethodRequire(bean, "bean");
        this.beanNullable = bean;
        return this;
    }

    public void ifNotPresent(Runnable runnable) {
        if (this.beanNullable == null) {
            runnable.run();
        }
    }

    public void ifPresent(Consumer<B> consumer) {
        if (this.beanNullable != null) {
            consumer.accept(this.beanNullable);
        }
    }

    @Deprecated
    public void ifPresent(Function<B, Void> function) {
        if (this.isPresent()) {
            function.apply(this.beanNullable);
        }
    }

    public boolean isNotPresent() {
        return !this.isPresent();
    }

    public boolean isPresent() {
        return this.beanNullable != null;
    }

    public <O> FinalUsefulBeanOptional<O> map(Function<B, O> function) {
        return FinalUsefulBeanOptional.of(this.showOptional().map(function));
    }
}

