/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.function;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.util.asserts.AssertUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class FinderStream<T> {
    protected final Predicate<T> condition;
    protected Map<Supplier<T>, Optional<Consumer<Integer>>> finderLink = new LinkedHashMap<Supplier<T>, Optional<Consumer<Integer>>>();

    protected FinderStream(Predicate<T> condition) {
        AssertUtil.assertMethodRequire(condition, "condition");
        this.condition = condition;
    }

    public static FinderStream<Boolean> findTrue() {
        return FinderStream.of(Boolean.TRUE::equals);
    }

    public static FinderStream<Boolean> findFalse() {
        return FinderStream.of(Boolean.FALSE::equals);
    }

    public static <T> FinderStream<T> findBean(Predicate<T> condition) {
        return FinderStream.of(Objects::nonNull);
    }

    public static <T> FinderStream<T> of(Predicate<T> condition) {
        return new FinderStream<T>(condition);
    }

    public static <T> FinderStream<T> requireIsNull(T bean) {
        return FinderStream.of(Objects::isNull);
    }

    public static <T> FinderStream<T> requireNotNull(T bean) {
        return FinderStream.of(Objects::nonNull);
    }

    public FinderStream<T> nextOptional(Optional<T> optional) {
        return this.next(() -> optional.orElse(null), Optional.empty());
    }

    public FinderStream<T> nextOptional(Optional<T> optional, Consumer<Integer> ifMiss) {
        AssertUtil.assertMethodRequire(ifMiss, "ifMiss");
        return this.nextOptional(() -> optional, ifMiss);
    }

    public FinderStream<T> nextOptional(Supplier<Optional<T>> optionalSupplier) {
        return this.next(() -> ((Optional)optionalSupplier.get()).orElse(null), Optional.empty());
    }

    public FinderStream<T> next(Supplier<T> supplier) {
        return this.next(supplier, Optional.empty());
    }

    protected FinderStream<T> next(Supplier<T> supplier, Optional<Consumer<Integer>> ifMissOptional) {
        AssertUtil.assertMethodRequire(supplier, "supplier");
        AssertUtil.assertMethodRequire(ifMissOptional, "ifMissOptional");
        AssertUtil.assertNotFatalBug(!this.finderLink.containsKey(supplier), "supplier\u51fa\u73b0\u91cd\u590d,\u7d22\u5f15:[%s]", this.finderLink.size());
        this.finderLink.put(supplier, ifMissOptional);
        return this;
    }

    public FinderStream<T> nextOptional(Supplier<Optional<T>> optionalSupplier, Consumer<Integer> ifMiss) {
        AssertUtil.assertMethodRequire(ifMiss, "ifMiss");
        return this.next(() -> ((Optional)optionalSupplier.get()).orElse(null), Optional.of(ifMiss));
    }

    public FinderStream<T> next(T bean, Consumer<Integer> ifMiss) {
        return this.next(() -> bean, Optional.of(ifMiss));
    }

    public FinderStream<T> next(Supplier<T> supplier, Consumer<Integer> ifMiss) {
        return this.next(supplier, Optional.of(ifMiss));
    }

    public T foundBean(StatusCode errorStatus, String message, Object ... params) {
        Optional<T> resultOptional = this.find();
        AssertUtil.simpleAssertByStatus(resultOptional.isPresent(), errorStatus, message, params);
        return resultOptional.orElseThrow(() -> new ServerException(Status.Server.fatalBug, "\u6846\u67b6\u51fa\u73b0bug,\u524d\u7aef\u65ad\u8a00\u51fa\u9519\u4e86", new Object[0]));
    }

    public Optional<T> find() {
        return this.findMatchConditionAsSupplier().map(Supplier::get);
    }

    public T findOrElse(T bean) {
        return this.find().orElse(bean);
    }

    public Optional<Supplier<T>> findMatchConditionAsSupplier() {
        ArrayList<Map.Entry<Supplier<T>, Optional<Consumer<Integer>>>> finderEntries = new ArrayList<Map.Entry<Supplier<T>, Optional<Consumer<Integer>>>>(this.finderLink.entrySet());
        for (int index = 0; index < finderEntries.size(); ++index) {
            int findIndex = index;
            Map.Entry<Supplier<T>, Optional<Consumer<Integer>>> finderEntry = finderEntries.get(index);
            Supplier<T> finder = finderEntry.getKey();
            Optional<Consumer<Integer>> onAbsentOptional = finderEntry.getValue();
            Object found = finder.get();
            if (this.condition.test(found)) {
                return Optional.of(() -> found);
            }
            onAbsentOptional.ifPresent(onAbsent -> onAbsent.accept(findIndex));
        }
        return Optional.empty();
    }
}

