/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.params;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.thread.AbstractObjectThreadHold;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadKeywordLikeFilter
extends AbstractObjectThreadHold<Map<String, List<String>>> {
    private Logger logger = LogManager.getLogger(ThreadKeywordLikeFilter.class);
    private Set<String> daoFilters;

    public ThreadKeywordLikeFilter(String ... daoFilters) {
        this.daoFilters = new HashSet<String>(Arrays.asList(daoFilters));
    }

    public ThreadKeywordLikeFilter filterIfPresent(String daoFilter, String ... keywords) {
        this.begin();
        if (keywords != null && (keywords = Stream.of(keywords).filter(Objects::nonNull).filter(k -> k.length() > 0).collect(Collectors.toList()).toArray(new String[0])).length > 0) {
            return this.filter(daoFilter, keywords);
        }
        return this;
    }

    public ThreadKeywordLikeFilter filter(String daoFilter, String ... keywords) {
        this.begin();
        AssertUtil.assertSupport(daoFilter != null, "filter\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        AssertUtil.assertSupport(this.daoFilters.contains(daoFilter), "filter:[%s]\u6ca1\u6709\u88ab\u6ce8\u518c", daoFilter);
        AssertUtil.assertSupport(keywords.length > 0, "\u4e0d\u652f\u6301\u4e0d\u4f20\u53c2\u6570\u7684filter", new Object[0]);
        HashMap<String, List<String>> map = (HashMap<String, List<String>>)this.get();
        if (map == null) {
            map = new HashMap<String, List<String>>();
            this.set(map);
        }
        for (String keyword : keywords) {
            AssertUtil.assertSupport(keyword != null && keyword.length() > 0, "filter\u4e0d\u652f\u6301\u7a7a\u5b57\u7b26\u4e32", new Object[0]);
        }
        map.put(daoFilter, Arrays.asList(keywords));
        this.logger.debug("\u7ebf\u7a0b\u4e2dKeywordLikeFilters\u88ab\u66f4\u65b0\u6210:{}", map);
        return this;
    }

    @Deprecated
    public String[] getKeyword(String daoFilter) {
        return this.queryKeyword(daoFilter).orElse(null);
    }

    public Optional<String[]> queryKeyword(String daoFilter) {
        Map map = (Map)this.get();
        if (map != null) {
            AssertUtil.assertSupport(this.daoFilters.contains(daoFilter), "filter:[%s]\u6ca1\u6709\u88ab\u6ce8\u518c", daoFilter);
            List keywords = (List)map.get(daoFilter);
            if (keywords != null) {
                this.logger.info("KeywordLikeFilters\u4ece\u7ebf\u7a0b\u4e2d\u53d6\u5230filter:[{}]\u53ef\u4ee5\u4f7f\u7528\u8fc7\u6ee4\u5173\u952e\u5b57:{}", (Object)daoFilter, (Object)keywords);
                return Optional.ofNullable(keywords.toArray(new String[0]));
            }
        }
        return Optional.empty();
    }

    public Set<String> getDaoFilters() {
        return this.daoFilters;
    }

    public void setDaoFilters(Set<String> daoFilters) {
        this.daoFilters = daoFilters;
    }
}

