/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics.summation;

import com.mini.framework.core.exception.LogicException;
import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateRange;
import com.mini.framework.util.function.FinalUsefulBean;
import com.mini.framework.util.report.statistics.protocol.StatisticsSerializeParams;
import com.mini.framework.util.report.statistics.protocol.SummationDimension;
import com.mini.framework.util.report.statistics.protocol.TimeRegionRange;
import com.mini.framework.util.report.statistics.protocol.TimeRegionUnit;
import com.mini.framework.util.report.statistics.protocol.params.QueryParamsOverview;
import com.mini.framework.util.report.statistics.protocol.process.ProcessContext;
import com.mini.framework.util.report.statistics.summation.SummationStatistics;
import com.mini.framework.util.report.statistics.summation.bean.NativeRegionChildrenRegionSummationLine;
import com.mini.framework.util.report.statistics.summation.bean.NativeRegionSummationElementAmount;
import com.mini.framework.util.report.statistics.summation.bean.NativeRegionTimeOutNames;
import com.mini.framework.util.report.statistics.summation.bean.SummationElementAmount;
import com.mini.framework.util.report.statistics.summation.bean.array.MultiParamsNativeRegionSummationArray;
import com.mini.framework.util.report.statistics.summation.bean.array.NativeRegionArraySummationArray;
import com.mini.framework.util.report.statistics.summation.bean.compare.BothSameRoundSummationCompare;
import com.mini.framework.util.report.statistics.summation.bean.compare.BothSummationCompare;
import com.mini.framework.util.report.statistics.summation.bean.compare.NativeRegionChildrenRegionSummationLineCompare;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public interface SummationDimensionFeature<P extends StatisticsSerializeParams>
extends SummationStatistics<P> {
    public SummationDimension showStatisticsDimension();

    @Override
    default public String showStatisticsFeatureKey() {
        return this.showStatisticsDimension().showDimensionStringKey();
    }

    public Optional<NativeRegionSummationElementAmount> queryNatureDateSummationRecord(P var1, String var2);

    public List<NativeRegionSummationElementAmount> queryBatchNatureDateSummationRecord(P var1, List<TimeRegionRange> var2);

    public void saveNatureDateSummationRecord(NativeRegionSummationElementAmount var1);

    default public List<NativeRegionSummationElementAmount> queryBatchNatureDateSummationRecord(String paramsUniqueSerializeMd5, Set<String> regionUnionKeys) {
        return this.queryMultiParamsBatchNatureDateSummationRecord(Stream.of(paramsUniqueSerializeMd5).collect(Collectors.toSet()), regionUnionKeys);
    }

    public List<NativeRegionSummationElementAmount> queryMultiParamsBatchNatureDateSummationRecord(Set<String> var1, Set<String> var2);

    public SummationElementAmount statisticsDateRangeSummationFromImpl(P var1, DateRange var2);

    public TimeRegionUnit acceptStatisticsOriginMaxUnit();

    public TimeRegionUnit acceptCacheStatisticsMinDateUnit();

    public Optional<TimeRegionUnit> acceptSkipStatisticsDefectDateUnit();

    public void previewValidateImpl();

    default public Date countUsefulHistoryLimitDate(Date historyLimitDate) {
        return this.acceptSkipStatisticsDefectDateUnit().map(unit -> unit.nearLazyFenceRangeDate(historyLimitDate)).orElse(historyLimitDate);
    }

    default public Function<String, CustomException> validateExceptionSupplierSummationAmountRight() {
        return error -> new ServerException(Status.Server.programConfigJava, "\u6c42\u548c\u8bb0\u5f55\u4e0d\u5b8c\u6574,%s", new Object[]{error});
    }

    public void executePersistentAddRecord(Runnable var1);

    default public void previewValidate() {
        Function<String, ServerException> supplier = message -> new ServerException(Status.Server.programConfigJava, "\u7a0b\u5e8f\u4f7f\u7528\u6709\u95ee\u9898\u9700\u8981\u68c0\u67e5utilFullyEmptyItem()\u51fa\u9519,%s", new Object[]{message});
        TimeRegionUnit originMaxUnit = this.acceptStatisticsOriginMaxUnit();
        List supportMaxUnits = Stream.of(TimeRegionUnit.year, TimeRegionUnit.season, TimeRegionUnit.month, TimeRegionUnit.day, TimeRegionUnit.week).collect(Collectors.toList());
        if (!supportMaxUnits.contains(originMaxUnit)) {
            throw supplier.apply(String.format("\u6700\u5927\u652f\u6301\u7684\u7edf\u8ba1\u70b9:[%s]\u5e94\u8be5\u5728\u6b64\u8303\u56f4\u5185:%s", originMaxUnit, supportMaxUnits));
        }
        this.previewValidateImpl();
    }

    default public SummationElementAmount statisticsDateRangeSummationFromImplWithTypeValidate(P params, DateRange dateRange) {
        SummationElementAmount implSummation = this.statisticsDateRangeSummationFromImpl(params, dateRange);
        implSummation.validateRight(error -> this.validateExceptionSupplierSummationAmountRight().apply(error));
        return implSummation;
    }

    default public boolean ifRequireSaveToCache(Date statisticsMaxDate, Date queryLimitDate) {
        return !queryLimitDate.before(statisticsMaxDate);
    }

    default public void validateNativeDateRegionRangeArray(TimeRegionUnit regionUnit, DateRange dateRange) {
        regionUnit.validateNativeDateRightPoint(dateRange, error -> new ServerException(Status.Server.programConfigJava, "\u7c7b\u578b\u4e3a:[%s],\u81ea\u7136\u65f6\u95f4\u5e8f\u5217\u53c2\u6570\u9519\u8bef%s\u672a\u4f5c\u524d\u7f6e\u68c0\u67e5,%s", new Object[]{regionUnit, dateRange, error}));
    }

    default public SummationElementAmount statisticsOneParamsDateRangeSummation(ProcessContext context, P params, DateRange dateRange, Date queryLimitDate) {
        this.previewValidate();
        Date realStatisticsLimitDate = this.countUsefulHistoryLimitDate(queryLimitDate);
        String paramsMd5Key = params.uniqueSerializeMd5();
        SummationElementAmount result = this.statisticsMultiParamsDateRangeSummation(context, Stream.of(params).collect(Collectors.toList()), dateRange, realStatisticsLimitDate).get(params.uniqueSerializeMd5());
        AssertUtil.assertNormal(result != null, () -> new LogicException(Status.Logic.def, "\u524d\u9762\u6570\u636e\u5904\u7406\u9519\u8bef,\u6ca1\u6709:[%s]\u5bf9\u5e94\u7ed3\u679c", new Object[]{paramsMd5Key}));
        result.markResultMeta(realStatisticsLimitDate);
        result.fillQueryProcess(context.getProcess());
        return result;
    }

    default public Map<String, SummationElementAmount> statisticsMultiParamsDateRangeSummation(ProcessContext context, List<P> paramsList, DateRange dateRange, Date queryLimitDate) {
        DateRange fullyStatisticsDateRange = dateRange.limitUpperDate(queryLimitDate);
        List paramsMd5List = paramsList.stream().map(StatisticsSerializeParams::uniqueSerializeMd5).collect(Collectors.toList());
        ArrayList regionChipDateRanges = new ArrayList();
        List<TimeRegionRange> requireQueryRegions = TimeRegionRange.splitRangeLessPointHandleChip(fullyStatisticsDateRange, this.acceptCacheStatisticsMinDateUnit(), this.acceptStatisticsOriginMaxUnit(), regionChipDateRanges::add);
        List<NativeRegionSummationElementAmount> cacheRegionSummations = this.queryMultiParamsBatchNatureDateSummationRecord(new HashSet<String>(paramsMd5List), requireQueryRegions.stream().map(TimeRegionRange::unitOffsetUnionString).collect(Collectors.toSet()));
        Map cacheRegionParamsMd5DateSummationMapper = cacheRegionSummations.stream().collect(Collectors.groupingByConcurrent(NativeRegionSummationElementAmount::showRegionAndParamsMd5UnionKey));
        cacheRegionParamsMd5DateSummationMapper.forEach((key, list) -> AssertUtil.assertDataComplete(list.size() == 1, "\u7edf\u8ba1\u4e4b\u6c42\u548c\u4e2d\u53d1\u73b0cache\u4e2d\u6709:[%s]\u4e2a\u91cd\u590d(key:[%s])\u7684\u6570\u636e:%s", list.size(), key, list));
        BiPredicate<StatisticsSerializeParams, TimeRegionRange> cacheParamsMd5RegionSummationsFound = (params, region) -> {
            String mapperKey = NativeRegionSummationElementAmount.showRegionAndParamsMd5UnionKey(region, params);
            return !cacheRegionParamsMd5DateSummationMapper.containsKey(mapperKey);
        };
        Map cacheParamsMd5SummationsMapper = cacheRegionSummations.stream().collect(Collectors.groupingByConcurrent(NativeRegionSummationElementAmount::getParamsSerializeMd5));
        HashMap<String, List> futureQueriesParamsMd5SummationsMapper = new HashMap<String, List>();
        paramsList.forEach(params -> {
            List futureQueries = requireQueryRegions.stream().filter(region -> cacheParamsMd5RegionSummationsFound.test((StatisticsSerializeParams)params, (TimeRegionRange)region)).sorted(TimeRegionRange.randomSorter()).map(region -> context.getProcess().pushQuery(this.statisticsNativeDateSummationFromCacheOrImplSupplier(context, (P)params, (TimeRegionRange)region, queryLimitDate), QueryParamsOverview.create((Object)params.uniqueSerializeMd5(), region))).collect(Collectors.toList());
            futureQueriesParamsMd5SummationsMapper.put(params.uniqueSerializeMd5(), futureQueries);
        });
        HashMap<String, List> chipFutureParamsMd5SummationsMapper = new HashMap<String, List>();
        paramsList.forEach(params -> {
            List summations = regionChipDateRanges.stream().map(regionChip -> context.getProcess().pushQuery(() -> this.statisticsDateRangeSummationFromImplWithTypeValidate((P)params, (DateRange)regionChip), QueryParamsOverview.create((Object)params.uniqueSerializeMd5(), regionChip))).collect(Collectors.toList());
            chipFutureParamsMd5SummationsMapper.put(params.uniqueSerializeMd5(), summations);
        });
        HashMap resultQueriesParamsMd5SummationsMapper = new HashMap();
        futureQueriesParamsMd5SummationsMapper.forEach((key, list) -> resultQueriesParamsMd5SummationsMapper.put(key, list.stream().map(Supplier::get).collect(Collectors.toList())));
        HashMap chipResultParamsMd5SummationsMapper = new HashMap();
        chipFutureParamsMd5SummationsMapper.forEach((key, list) -> chipResultParamsMd5SummationsMapper.put(key, list.stream().map(Supplier::get).collect(Collectors.toList())));
        HashMap<String, SummationElementAmount> resultMapper = new HashMap<String, SummationElementAmount>();
        paramsList.stream().map(StatisticsSerializeParams::uniqueSerializeMd5).forEach(paramsMd5 -> {
            SummationElementAmount paramsMd5AllSummation = Stream.of((List)cacheParamsMd5SummationsMapper.get(paramsMd5), (List)resultQueriesParamsMd5SummationsMapper.get(paramsMd5), (List)chipResultParamsMd5SummationsMapper.get(paramsMd5)).filter(Objects::nonNull).flatMap(Collection::stream).map(SummationElementAmount::refAsSummationElementAmount).reduce(SummationElementAmount.createEmptyInstance(), SummationElementAmount::mergeAmount);
            resultMapper.put((String)paramsMd5, paramsMd5AllSummation);
        });
        return resultMapper;
    }

    default public Supplier<SummationElementAmount> statisticsNativeDateSummationFromCacheOrImplSupplier(ProcessContext context, P params, TimeRegionRange regionRange, Date queryLimitDate) {
        return () -> this.statisticsNativeDateSummationFromCacheOrImpl(context, params, regionRange, queryLimitDate);
    }

    default public SummationElementAmount statisticsNativeDateSummationFromCacheOrImpl(ProcessContext context, P params, TimeRegionRange regionRange, Date queryLimitDate) {
        Date realStatisticsLimitDate = this.countUsefulHistoryLimitDate(queryLimitDate);
        Optional<NativeRegionSummationElementAmount> implAmountOptional = this.queryNatureDateSummationRecord(params, regionRange.unitOffsetUnionString());
        DateRange requireDateRange = regionRange.showDateRange().limitUpperDate(realStatisticsLimitDate);
        return implAmountOptional.map(a -> a).orElseGet(() -> {
            SummationElementAmount summation = this.statisticsDateRangeSummationFromImplWithTypeValidate(params, requireDateRange);
            if (this.ifRequireSaveToCache(regionRange.mapperToDate(), queryLimitDate)) {
                FinalUsefulBean<Boolean> bean = FinalUsefulBean.of(false);
                this.executePersistentAddRecord(() -> {
                    bean.apply(b -> true);
                    this.saveNatureDateSummationRecord(NativeRegionSummationElementAmount.create(params, regionRange, summation));
                });
                AssertUtil.assertNotFatalBug(bean.get(), "\u5de5\u5177\u4f7f\u7528\u5f02\u5e38 \u65b9\u6cd5executePersistentAddRecord(Runnable)\u4e2dRunnable\u53c2\u6570\u5fc5\u987b\u662f\u88abrun\u4e86\u7684", new Object[0]);
            }
            summation.markResultMeta(realStatisticsLimitDate);
            summation.fillQueryProcess(context.getProcess());
            return summation;
        });
    }

    @Override
    default public NativeRegionSummationElementAmount statisticsNativeDateSummation(ProcessContext context, P params, TimeRegionRange regionRange, Date queryLimitDate) {
        this.previewValidate();
        Date realStatisticsLimitDate = this.countUsefulHistoryLimitDate(queryLimitDate);
        SummationElementAmount summationAmount = this.statisticsOneParamsDateRangeSummation(context, params, regionRange.showDateRange(), queryLimitDate);
        NativeRegionSummationElementAmount result = NativeRegionSummationElementAmount.create(params, regionRange, summationAmount);
        result.markResultMeta(realStatisticsLimitDate);
        result.fillQueryProcess(context.getProcess());
        return result;
    }

    @Override
    default public MultiParamsNativeRegionSummationArray<P> statisticsMultiParamsNativeDateSummation(ProcessContext context, List<P> paramsList, TimeRegionRange regionRange, Date queryLimitDate) {
        this.previewValidate();
        Date realStatisticsLimitDate = this.countUsefulHistoryLimitDate(queryLimitDate);
        Map<String, SummationElementAmount> mapper = this.statisticsMultiParamsDateRangeSummation(context, paramsList, regionRange.showDateRange(), realStatisticsLimitDate);
        MultiParamsNativeRegionSummationArray result = new MultiParamsNativeRegionSummationArray();
        result.markResultMeta(realStatisticsLimitDate);
        result.fillQueryProcess(context.getProcess());
        paramsList.forEach(params -> {
            SummationElementAmount amount = (SummationElementAmount)mapper.get(params.uniqueSerializeMd5());
            AssertUtil.assertNormal(amount != null, () -> new LogicException(Status.Logic.def, "\u524d\u9762\u6570\u636e\u5904\u7406\u9519\u8bef,\u6ca1\u6709params:[%s]\u5bf9\u5e94\u7ed3\u679c", new Object[]{params.uniqueSerialize()}));
            NativeRegionSummationElementAmount summation = NativeRegionSummationElementAmount.create(params, regionRange, amount);
            result.add(params, summation);
        });
        return result;
    }

    @Override
    default public BothSummationCompare statisticsNativeDateSummationWithBothCompare(ProcessContext context, P params, TimeRegionRange regionRange, Date queryLimitDate, int compareIndexOffset) {
        this.previewValidate();
        Date realStatisticsLimitDate = this.countUsefulHistoryLimitDate(queryLimitDate);
        TimeRegionRange compareRange = regionRange.nextRegionRange(compareIndexOffset);
        Function<TimeRegionRange, NativeRegionSummationElementAmount> regionRangeSummationMapper = this.statisticsRegionRangeArraySummationArrayPromiseNotOut(context, params, Stream.of(regionRange, compareRange).collect(Collectors.toList()), realStatisticsLimitDate);
        BothSummationCompare result = BothSummationCompare.createSummationInstance(regionRangeSummationMapper.apply(regionRange), regionRangeSummationMapper.apply(compareRange));
        result.markResultMeta(realStatisticsLimitDate);
        result.fillQueryProcess(context.getProcess());
        return result;
    }

    @Override
    default public BothSameRoundSummationCompare statisticsNativeDateSummationWithSameRoundCompare(ProcessContext context, P params, TimeRegionRange regionRange, Date queryLimitDate, int roundCompareIndexOffset, int sameCompareIndexOffset, Optional<TimeRegionUnit> sameCompareUnitOptional) {
        Date realStatisticsLimitDate = this.countUsefulHistoryLimitDate(queryLimitDate);
        TimeRegionRange roundCompareRange = regionRange.nextRegionRange(roundCompareIndexOffset);
        Optional<TimeRegionRange> sameCompareRangeOptional = sameCompareUnitOptional.map(scopeUnit -> regionRange.nextSameRegionRange((TimeRegionUnit)scopeUnit, sameCompareIndexOffset));
        List<TimeRegionRange> regions = Stream.of(roundCompareRange, regionRange).collect(Collectors.toList());
        sameCompareRangeOptional.ifPresent(regions::add);
        Function<TimeRegionRange, NativeRegionSummationElementAmount> regionRangeSummationMapper = this.statisticsRegionRangeArraySummationArrayPromiseNotOut(context, params, regions, realStatisticsLimitDate);
        BothSameRoundSummationCompare result = BothSameRoundSummationCompare.create(regionRangeSummationMapper.apply(regionRange), regionRangeSummationMapper.apply(roundCompareRange), sameCompareRangeOptional.map(regionRangeSummationMapper));
        result.markResultMeta(realStatisticsLimitDate);
        result.fillQueryProcess(context.getProcess());
        return result;
    }

    @Override
    default public SummationElementAmount statisticsNativeDateArraySummation(ProcessContext context, P params, TimeRegionUnit regionUnit, DateRange dateRange, Date queryLimitDate) {
        this.previewValidate();
        this.validateNativeDateRegionRangeArray(regionUnit, dateRange);
        Date rangeMinDate = dateRange.getMinDate();
        Date rangeMaxDate = dateRange.getMaxDate();
        return this.statisticsOneParamsDateRangeSummation(context, params, DateRange.create(rangeMinDate, rangeMaxDate), queryLimitDate);
    }

    @Override
    default public SummationElementAmount statisticsCustomDateRangeSummation(ProcessContext context, P params, DateRange dateRange, Date queryLimitDate) {
        return this.statisticsOneParamsDateRangeSummation(context, params, dateRange, queryLimitDate);
    }

    @Override
    default public NativeRegionArraySummationArray statisticsNativeDateArrayScatterSummation(ProcessContext context, P params, TimeRegionUnit regionUnit, DateRange dateRange, Date queryLimitDate) {
        this.previewValidate();
        Date realStatisticsLimitDate = this.countUsefulHistoryLimitDate(queryLimitDate);
        this.validateNativeDateRegionRangeArray(regionUnit, dateRange);
        List<TimeRegionRange> requireRanges = regionUnit.regionFences(dateRange.getMinDate(), dateRange.getMaxDate());
        NativeRegionArraySummationArray result = this.statisticsRegionRangeArraySummationArray(context, params, requireRanges, queryLimitDate);
        result.markResultMeta(realStatisticsLimitDate);
        result.fillQueryProcess(context.getProcess());
        result.fillArraySequenceAccumulates();
        return result;
    }

    default public Function<TimeRegionRange, NativeRegionSummationElementAmount> statisticsRegionRangeArraySummationArrayPromiseNotOut(ProcessContext context, P params, List<TimeRegionRange> regionRanges, Date queryLimitDate) {
        this.previewValidate();
        return this.statisticsRegionRangeArraySummationArray(context, params, regionRanges, queryLimitDate, key -> {
            throw new ServerException("key:[%s]\u9519\u8bef\u627e\u4e0d\u5230\u6570\u636e\u8d85\u51fa\u7684\u8ba1\u5212\u7684\u6570\u636e", new Object[]{key});
        });
    }

    default public Function<TimeRegionRange, NativeRegionSummationElementAmount> statisticsRegionRangeArraySummationArray(ProcessContext context, P params, List<TimeRegionRange> regionRanges, Date queryLimitDate, Function<TimeRegionRange, NativeRegionSummationElementAmount> ifOutKeySupplier) {
        this.previewValidate();
        List<NativeRegionSummationElementAmount> allSummation = this.statisticsRegionRangeArraySummationArray(context, params, regionRanges, queryLimitDate).getElements();
        return regionRange -> allSummation.stream().filter(summation -> summation.mapperRegionRange().match((TimeRegionRange)regionRange)).findFirst().orElseGet(() -> (NativeRegionSummationElementAmount)ifOutKeySupplier.apply((TimeRegionRange)regionRange));
    }

    default public NativeRegionArraySummationArray statisticsRegionRangeArraySummationArray(ProcessContext context, P params, List<TimeRegionRange> regionRanges, Date queryLimitDate) {
        this.previewValidate();
        Date realStatisticsLimitDate = this.countUsefulHistoryLimitDate(queryLimitDate);
        List<NativeRegionSummationElementAmount> cacheSummations = this.queryBatchNatureDateSummationRecord(params, regionRanges);
        Map regionUnionKeySummationMapper = cacheSummations.stream().collect(Collectors.toMap(NativeRegionSummationElementAmount::getRegionUnionKey, Function.identity()));
        List<NativeRegionSummationElementAmount> allSummation = regionRanges.stream().map(requireRange -> Optional.ofNullable(regionUnionKeySummationMapper.get(requireRange.unitOffsetUnionString())).orElseGet(() -> {
            NativeRegionSummationElementAmount thisRangeSummation = this.statisticsNativeDateSummation(context, params, (TimeRegionRange)requireRange, realStatisticsLimitDate);
            return NativeRegionSummationElementAmount.create(params, requireRange, thisRangeSummation);
        })).collect(Collectors.toList());
        NativeRegionArraySummationArray result = NativeRegionArraySummationArray.create(allSummation);
        result.markResultMeta(realStatisticsLimitDate);
        result.fillQueryProcess(context.getProcess());
        result.fillArraySequenceAccumulates();
        return result;
    }

    @Override
    default public NativeRegionChildrenRegionSummationLine statisticsNativeDateChildrenArraySummationLine(ProcessContext context, P params, TimeRegionRange regionRange, TimeRegionUnit childrenRegionUnit, Date queryLimitDate) {
        this.previewValidate();
        Date realStatisticsLimitDate = this.countUsefulHistoryLimitDate(queryLimitDate);
        List<TimeRegionRange> childrenRegionRanges = regionRange.findElementRegionFences(childrenRegionUnit);
        List<NativeRegionSummationElementAmount> summations = this.statisticsRegionRangeArraySummationArray(context, params, childrenRegionRanges, realStatisticsLimitDate).getElements();
        Function<Date, NativeRegionTimeOutNames> dateOutNameMapper = NativeRegionTimeOutNames.nativeUnitOutName(regionRange, childrenRegionUnit);
        summations.forEach(summation -> summation.fillOutNames(dateOutNameMapper));
        NativeRegionChildrenRegionSummationLine result = NativeRegionChildrenRegionSummationLine.create(regionRange.getOffset(), regionRange.getUnit(), childrenRegionUnit, summations);
        result.markResultMeta(realStatisticsLimitDate);
        result.fillQueryProcess(context.getProcess());
        result.fillArraySequenceAccumulates();
        return result;
    }

    @Override
    default public NativeRegionChildrenRegionSummationLineCompare statisticsNativeDateChildrenArraySummationLineWithCompare(ProcessContext context, P params, TimeRegionRange regionRange, TimeRegionUnit childrenRegionUnit, Date queryLimitDate, int[] compareIndexOffsets) {
        this.previewValidate();
        Date realStatisticsLimitDate = this.countUsefulHistoryLimitDate(queryLimitDate);
        Set allIndexOffsets = IntStream.of(compareIndexOffsets).boxed().collect(Collectors.toSet());
        allIndexOffsets.add(0);
        List<TimeRegionRange> requireSummationRegions = allIndexOffsets.stream().distinct().sorted().map(regionRange::nextRegionRange).map(range -> range.findElementRegionFences(childrenRegionUnit)).flatMap(Collection::stream).collect(Collectors.toList());
        Function<TimeRegionRange, NativeRegionSummationElementAmount> regionSummationLineFinder = this.statisticsRegionRangeArraySummationArrayPromiseNotOut(context, params, requireSummationRegions, realStatisticsLimitDate);
        Function<Integer, NativeRegionChildrenRegionSummationLine> indexOffsetSummationLineFinder = indexOffset -> {
            TimeRegionRange indexRegionRange = regionRange.nextRegionRange((int)indexOffset);
            List<NativeRegionSummationElementAmount> summations = indexRegionRange.findElementRegionFences(childrenRegionUnit).stream().map(regionSummationLineFinder).collect(Collectors.toList());
            return NativeRegionChildrenRegionSummationLine.create(indexRegionRange.getOffset(), indexRegionRange.getUnit(), childrenRegionUnit, summations);
        };
        List<NativeRegionChildrenRegionSummationLine> contrastLines = IntStream.of(compareIndexOffsets).sorted().boxed().map(indexOffsetSummationLineFinder).collect(Collectors.toList());
        NativeRegionChildrenRegionSummationLine mainLine = indexOffsetSummationLineFinder.apply(0);
        NativeRegionChildrenRegionSummationLineCompare result = NativeRegionChildrenRegionSummationLineCompare.create(mainLine, contrastLines);
        result.markResultMeta(realStatisticsLimitDate);
        result.fillQueryProcess(context.getProcess());
        result.fillArraySequenceAccumulates();
        return result;
    }
}

