/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.score;

import java.util.Date;

public class NewtonCoolingUtil {
    private int astringeCycle;
    private int astringeTimeUnit;

    public int getAstringeCycle() {
        return this.astringeCycle;
    }

    public void setAstringeCycle(int astringeCycle) {
        this.astringeCycle = astringeCycle;
    }

    public int getAstringeTimeUnit() {
        return this.astringeTimeUnit;
    }

    public void setAstringeTimeUnit(int astringeTimeUnit) {
        this.astringeTimeUnit = astringeTimeUnit;
    }

    public NewtonCoolingUtil(int astringeCycle, int astringeTimeUnit) {
        this.astringeCycle = astringeCycle;
        this.astringeTimeUnit = astringeTimeUnit;
    }

    public static NewtonCoolingUtil createSeconds(int astringeCycle) {
        return NewtonCoolingUtil.create(astringeCycle, 1000);
    }

    public static NewtonCoolingUtil createMinute(int astringeCycle) {
        return NewtonCoolingUtil.create(astringeCycle, 60000);
    }

    public static NewtonCoolingUtil create(int astringeCycle, int astringeTimeUnit) {
        return new NewtonCoolingUtil(astringeTimeUnit, astringeTimeUnit);
    }

    public double coolingScoreIncrement(Date oldDate, Date newDate) {
        long times = (newDate.getTime() - oldDate.getTime()) / (long)this.astringeTimeUnit;
        return Math.pow(0.01, 1.0 * (double)times / (double)this.astringeCycle);
    }

    public double coolingNextScore(Date oldDate, Date newDate, double oldScore) {
        double newScore = oldScore * this.coolingScoreIncrement(oldDate, newDate);
        return newScore;
    }
}

