/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.sql.view.bean;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.sql.view.able.ObjectValueReader;
import com.mini.framework.util.sql.view.bean.ColumnDefine;
import com.mini.framework.util.sql.view.bean.ObjectStringValueType;
import com.mini.framework.util.sql.view.bean.SqlViewBean;
import java.util.Date;
import java.util.Optional;

public class ColumnValue
extends SqlViewBean {
    private String key;
    private ObjectStringValueType type;
    private String value;

    public static ColumnValue fromReader(ObjectValueReader reader, ColumnDefine define) {
        Optional<Object> originValueOptional = reader.read(define.getKey());
        ColumnValue instance = new ColumnValue();
        instance.key = define.getKey();
        instance.type = define.getValueType();
        originValueOptional.ifPresent(originValue -> {
            switch (instance.type) {
                case date: {
                    AssertUtil.assertNormal(originValue instanceof Date, () -> new ServerException("key:[%s]\u5bf9\u5e94\u7684\u503c\u7c7b\u578b\u662f:[%s]\u65e0\u6cd5\u89e3\u6790\u6210\u65e5\u671f\u503c\u4e3a:[%s]", new Object[]{instance.key, originValue.getClass(), originValue}));
                    instance.value = String.valueOf(((Date)originValue).getTime());
                    break;
                }
                default: {
                    instance.value = originValue.toString();
                }
            }
        });
        return instance;
    }

    public String getKey() {
        return this.key;
    }

    public ColumnValue setKey(String key) {
        this.key = key;
        return this;
    }

    public ObjectStringValueType getType() {
        return this.type;
    }

    public ColumnValue setType(ObjectStringValueType type) {
        this.type = type;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public ColumnValue setValue(String value) {
        this.value = value;
        return this;
    }
}

