package com.mini.framework.util.cache.prepare.merge.data;

/**
 * 预缓存的执行器
 * @author jayheo
 */
public interface PrepareAtomCacheExecutor {


    /**
     * 执行写入增量的操作
     * @param key
     * @param increment
     * @return 得到修改后的结果
     */
    int writeIncrement(String key,int increment);


    /**
     * 写入 交换区 的增量的操作
     * @param key
     * @param increment
     * @return
     */
    default int writeSwapStoreIncrement(String key,int increment){
        return writeIncrement(mapperSwapStoreKey(key),increment);
    }


    /**
     * 查询剩余量
     * re
     * */
    int querySurplus(String key);


    /**
     * 查询交换区的剩余量
     * @param key
     * @return
     */
    default int querySwapStoreSurplus(String key){
        return querySurplus(mapperSwapStoreKey(key));
    }



    /**
     * 截取剩余量
     * @return 返回当前的剩余量
     * */
    int cutSurplus(String key);

    /**
     * 从交换区
     * 截取剩余量
     * @param key
     * @return
     */
    default int cutSwapStoreSurplus(String key){
        return cutSurplus(mapperSwapStoreKey(key));
    }




    default String itemSplit(){
        return ":";
    }


    /**
     * 找到对应的，交换区的key
     * @param key
     * @return
     */
    default String mapperSwapStoreKey(String key){
        return String.join(itemSplit(),key,"swap","store");
    }

}
