package com.mini.framework.util.export.protocol.branch;

import com.mini.framework.core.code.standard.style01.flag.define.CodeStandardDefineFind;

import java.util.Optional;
import java.util.stream.Stream;

/**
 * 多个分支案例
 * @author jayheo
 */
public @interface SwitchCases {


    /**
     * 根据名字分案例区分
     * @return
     */
    NameSwitchCase[] nameCases() default {};


    /**
     * 根据 布尔值案例区分
     * @return
     */
    BooleanSwitchCase[] booleanCases() default {};


    /**
     * 一个静态的支持类
     */
    static interface Support{

        /**
         * 查找可能的案例结果
         * @param switchCases
         * @param origin
         * @return
         */
        @CodeStandardDefineFind
        static Optional<String> findCasesResult(SwitchCases switchCases, String origin){
            return Stream.of(
                findResultOnlyBooleanCases(switchCases, origin)
                ,findResultOnlyNameCases(switchCases, origin)
            )
            .filter(Optional::isPresent)
            .map(Optional::get)
            .findFirst();
        }


       @CodeStandardDefineFind
        static Optional<String> findResultOnlyNameCases(SwitchCases switchCases, String origin){
            return Stream.of(switchCases.nameCases())
                    .map(nameSwitchCase -> NameSwitchCase.Support.findCaseResult(nameSwitchCase,origin))
                    .filter(Optional::isPresent)
                    .map(Optional::get)
                    .findFirst();
        }


       @CodeStandardDefineFind
        static Optional<String> findResultOnlyBooleanCases(SwitchCases switchCases, String origin){
            return Stream.of(switchCases.booleanCases())
                    .map(nameSwitchCase -> BooleanSwitchCase.Support.findCaseResult(nameSwitchCase,origin))
                    .filter(Optional::isPresent)
                    .map(Optional::get)
                    .findFirst();
        }


        /**
         * 应用可能的案例
         * @param switchCases
         * @param origin
         * @return
         */
        static String applyCases(SwitchCases switchCases,String origin){
            return findCasesResult(switchCases, origin).orElse(origin);
        }
    }

}
