package com.mini.framework.util.function;

import com.mini.framework.util.asserts.AssertUtil;

import java.util.function.Function;

/**
 * 在要求使用 final 修饰的方法参数时,可以使用此类来包装
 * @author jayheo
 */
public class FinalUsefulBean<B> {

    private B bean;

    /**
     * @deprecated 要换成 FinalUsefulBeanOptional
     * @param bean
     */
    @Deprecated
    public FinalUsefulBean(B bean) {
        this.bean = bean;
    }

    public static <B> FinalUsefulBean<B> of(B bean){
        AssertUtil.assertMethodRequire(bean,"bean");
        return new FinalUsefulBean<>(bean);
    }

    public B get() {
        return bean;
    }

    public FinalUsefulBean<B> set(B bean) {
        AssertUtil.assertMethodRequire(bean,"bean");
        this.bean = bean;
        return this;
    }

    public FinalUsefulBean<B> apply(Function<B,B> function){
        B bean = function.apply(this.bean);
        AssertUtil.assertMethodRequire(bean,"bean");
        this.bean = bean;
        return this;
    }
}
