package com.mini.framework.util.function;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

/**
 * 对Function的扩展
 * @author jayheo
 *
 */
public interface FunctionSpread {

	/**
	 * 通过一个map得到转化器
	 * @param map
	 * @return
	 */
	static <T, R> Function<T, R> fromMap(Map<T, R> map) {
		return t -> map.get(t);
	}
	
	/**
	 * 通过集合得到一个映射
	 * @param coll
	 * @param RT
	 * @return
	 */
	static <T, R> Function<T, R> fromColl(Collection<R> coll,Function<R, T>RT ){
		return fromColl(coll, RT, Function.identity());
	}
	
	/**
	 * 通过集合得到一个映射
	 * @param coll
	 * @param ET
	 * @param ER
	 * @return
	 */
	static <E,T, R> Function<T, R> fromColl(Collection<E> coll,Function<E, T>ET,Function<E, R> ER ){
		Map<T,R> map = new HashMap<>();
		coll.stream().forEach(item->map.put(ET.apply(item),ER.apply(item)));
		return fromMap(map);
	}
	
	static <K,V,VV> Map<K, VV> mapperValue(Map<K, V>target,Function<V, VV> vv){
		Map<K, VV> map = new HashMap<>();
		target.forEach((k,v)->map.put(k, vv.apply(v)));
		return map ;
	}
	
	static <K,KK,V> Map<KK, V> mapperKey(Map<K, V>target,Function<K, KK> kk){
		Map<KK, V> map = new HashMap<>();
		target.forEach((k,v)->map.put(kk.apply(k), v));
		return map ;
	}
	
	/**
	 * 给Function 增加一个参数一般用于Stream.map(Function);
	 * @param u
	 * @param bf
	 * @return
	 */
	static<T,U, R> Function<T, R> applySecondParam(U u,BiFunction<T, U, R> bf){
		return t-> bf.apply(t, u);
	}

}
