package com.mini.framework.util.generic.define;

import com.mini.framework.core.exception.standard.UnsupportedException;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 *
 TODO 需要添加junit和javadoc
 * 可能的 set String
 *
 * @author jayheo
 * */
public class OptionalSetString extends OptionalSet<String> {


    private static OptionalSetString createEmpty (){
        return new OptionalSetString();
    }

    public static OptionalSetString ofNullable(Collection<String> collString){
        return collString==null? createEmpty() :of(collString);
    }

    /**
     * 从集合中取出来
     * */
    public static OptionalSetString of(Collection<String> collString){
        OptionalSetString set = new OptionalSetString();
        Objects.requireNonNull(collString,"collString不能为空");
        set.value = new LinkedHashSet<>(collString);
        return set;
    }

    public static OptionalSetString ofNullable(String... ts){
        return ts==null? createEmpty() :of(ts);
    }

    /**
     * 从数据中取出来
     * */
    public static OptionalSetString of(String... ts){
        return of(Stream.of(ts).collect(Collectors.toSet()));
    }


    public static OptionalSetString ofNullable(String arr){
        return arr==null? createEmpty() :of(arr);
    }

    public Optional<Set<String>> out(){
        return out(false);
    }

    public Optional<Set<String>> outNotZero(){
        return out(true);
    }

    public Optional<Set<String>> out(boolean zeroAsNull){
        if(zeroAsNull && (value!=null&& value.isEmpty())){
            return Optional.empty();
        }
        return Optional.ofNullable(value);
    }


    @Override
    public String toString() {
        return out().toString();
    }

}
