package com.mini.framework.util.http;

import java.util.Map;

/**
 * 普通的get请求器
 * @author jayheo
 *
 */
public class SimpleHttpPostReqer implements SimpleHttpReqable{
	
	private boolean bodyMode;


	private String body;
	
	private Map<String, String> params;

	private Map<String,String> headers;
	
	public SimpleHttpPostReqer( String body) {
		super();
		this.bodyMode = true;
		this.body = body;
	}

	public SimpleHttpPostReqer( Map<String, String> params) {
		super();
		this.params = params;
	}

	public SimpleHttpPostReqer( String body, Map<String, String> headers) {
		this.bodyMode = true;
		this.body = body;
		this.headers = headers;
	}

	@Override
	public String req(String url) {
		if(bodyMode){
			if (headers == null){
				return SimpleHttpUtil.simplePost(url, body);
			}else {
				return SimpleHttpUtil.simplePost(url,body,headers);
			}
		}else if(params!=null){
			return SimpleHttpUtil.simplePost(url, params);
		}else{
			return SimpleHttpUtil.simplePost(url);
		}
	}

}
