package com.mini.framework.util.http.linked;

import com.mini.framework.util.string.StringUtil;

public class HttpResponse {

	private HttpHeaders headers;

	private byte[] body;

	private int status;
	
	private boolean abort; 
	
	private HttpRequest request;

	public HttpResponse() {}
	public static HttpResponse createAbort(HttpRequest request) {
		HttpResponse resp = new HttpResponse();
		resp.setRequest(request);
		resp.setAbort(true);
		return resp;
	}
	public HttpResponse(HttpRequest request, int status,HttpHeaders headers, byte[] body) {
		super();
		this.request = request;
		this.headers = headers;
		this.body = body;
		this.status = status;
	}

	public HttpHeaders getHeaders() {
		return headers;
	}

	public void setHeaders(HttpHeaders headers) {
		this.headers = headers;
	}
	
	public byte[] getBody() {
		return body;
	}

	public String getBodyString() {
		return StringUtil.toUtf8String(body);
		//return byteToString(body, charset );
	}

	public void setBody(byte[] body) {
		this.body = body;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}
	
	public boolean isAbort() {
		return abort;
	}
	public void setAbort(boolean abort) {
		this.abort = abort;
	}
	public HttpRequest getRequest() {
		return request;
	}
	public void setRequest(HttpRequest request) {
		this.request = request;
	}
	
	public <T> T hande( HttpResponseHandler<T> hander){
		return hander.hande(this);
	}
}