package com.mini.framework.util.optional;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 可能的 Date
 * TODO 需要添加junit和javadoc
 * @see com.mini.framework.util.generic.define.OptionalDate
 * @author jayheo
 * */
//
@Deprecated
public class OptionalDate{


    private Date date;

    private static final OptionalDate createEmpty (){
        return new OptionalDate();
    }


    public static OptionalDate of(String dateString){
        long dateLong = Long.parseLong(dateString);
        return of(dateLong);
    }


    public static OptionalDate of(long dateLong){
        return of(new Date(dateLong));
    }


    public static OptionalDate ofNullable(Long dateLong){
        return dateLong==null? createEmpty() :of(dateLong);
    }

    public static OptionalDate ofNullable(String dateString){
        return dateString==null? createEmpty() :of(dateString);
    }

    public static OptionalDate ofNullable(Date date){
        return date==null? createEmpty() :of(date);
    }

    /**
     * 从数据中取出来
     * */
    public static OptionalDate of(Date date){
        OptionalDate optional = new OptionalDate();
        optional.date = date;
        return optional;
    }


    public Optional<Date> out(){
        return Optional.ofNullable(date);
    }

    @Override
    public String toString() {
        return out().toString();
    }
}
