package com.mini.framework.util.oss.bean.offset;

/**
 * 九宫格位置水印类型
 * 
 * @author jayheo
 *
 */
public enum JiugePalaceOffsetWaterMarkType {
	
	//TODO 请谭雄伟加上注释。
	//https://help.aliyun.com/document_detail/44957.html?spm=a2c4g.11186623.6.1400.5e7bc1f69uq2XJ
	nw(0,0), north(0,1), ne(0,2), west(1,0), center(1,1), east(1,2), sw(2,0), south(2,1), se(2,2);
	
	private int nsIndex;
	private int weIndex;
	
	public int getNsIndex() {
		return nsIndex;
	}

	public void setNsIndex(int nsIndex) {
		this.nsIndex = nsIndex;
	}

	public int getWeIndex() {
		return weIndex;
	}

	public void setWeIndex(int weIndex) {
		this.weIndex = weIndex;
	}

	private JiugePalaceOffsetWaterMarkType(int nsIndex, int weIndex) {
		this.nsIndex = nsIndex;
		this.weIndex = weIndex;
	}

	/**
	 * 得到由南向北的位置点
	 * @return
	 */
	public int nsOffset(int height){
		return Math.round(((height/3) * (nsIndex + 0.5f)));
	}
	
	/**
	 * 得到由西向东的位置
	 * @return
	 */
	public int weOffset(int width){
		return Math.round(((width/3) * (weIndex + 0.5f)));
	}

}
