package com.mini.framework.util.oss.bean.work;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

import com.mini.framework.util.asserts.AssertUtil;
import org.apache.commons.collections4.CollectionUtils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mini.framework.util.bean.desc.Desc;
import com.mini.framework.util.bean.desc.Descable;
import com.mini.framework.util.oss.bean.OssImageProcessParams;
import com.mini.framework.util.oss.bean.work.mark.HaveMarkPhotoFrame;
import com.mini.framework.util.oss.bean.work.mark.ImageMarkOssImageWork;
import com.mini.framework.util.oss.bean.work.mark.TextMarkOssImageWork;
import com.mini.framework.util.oss.bean.work.modify.CircleByRadiusOssImageWork;
import com.mini.framework.util.oss.bean.work.modify.CircleByRoundedCornersOssImageWork;
import com.mini.framework.util.oss.bean.work.modify.LimitResizeModifyOssImageWork;
import com.mini.framework.util.oss.bean.work.modify.OffsetCropModifyOssImageWork;
import com.mini.framework.util.oss.bean.work.modify.RoundedCornersModifyOssImageWork;
import com.mini.framework.util.photo.PhotoBodilyFormType;
import com.mini.framework.util.string.GsonUtil;
import com.mini.framework.util.string.RegexUtil;

/**
 * oss处理进程
 * @author jayheo
 */
public class OssWorkProcess implements Descable,HaveMarkPhotoFrame {
	

	@Desc("需要处理的工作流程")
	private List<OssImageWork> works;

	private static UnaryOperator<GsonBuilder> gsonBuilderUnaryOperator(){
		return builder->
		builder	.registerTypeAdapter(OssImageWork.class, new OssImageWorkDeserializer())
			.registerTypeAdapter(OssImageWork.class, new OssImageWorkSerializer());
	}


	/**
	 * 当前使用的gson
	 * @return
	 */
	private static Gson currFitGson(){
		return GsonUtil.createBaseBuilder(gsonBuilderUnaryOperator()).create();
	}
	
	public List<OssImageWork> getWorks() {
		return works;
	}

	public void setWorks(List<OssImageWork> works) {
		this.works = works;
	}
	public static OssWorkProcess create(OssImageWork... works) {
		return new OssWorkProcess(works);
	}
	public OssWorkProcess(OssImageWork... works) {
		addWorks(works);
	}
	
	public List<OssImageWork> sureHaveWorks(){
		if(this.works== null){
			this.works = new ArrayList<OssImageWork>();
		}
		return works;
	}
	
	
	public <W extends OssImageWork> OssWorkProcess addWorks(W... works) {
		CollectionUtils.addAll(sureHaveWorks(),works);
		return this;
	}
	
	public String toJson(){
		return currFitGson().toJson(this);
	}


	/**
	 * 通过json解析出oss处理进程
	 * @param json 对应的json 不允许为空
	 * @return
	 */
	public static OssWorkProcess fromJson(String json){
		AssertUtil.assertMethodRequire(json,"json");
		return currFitGson().fromJson(json, OssWorkProcess.class);
	}
	
	@Override
	public UnaryOperator<GsonBuilder> registerGsonBuilder() {
		return gsonBuilderUnaryOperator() ;
	}
	
	public String toOssUrl(String url,BiFunction<String, String, String> sameBucketPathFunction){
		String bucketHost = RegexUtil.getUrlHost(url);
		List<OssImageWork> works = sureHaveWorks();
		//TODO 加上线程中的缓存使用 类似 holdSupplier 可能是使用 holdValueSupplier
		Function<String, String> fn = image->sameBucketPathFunction.apply(image, bucketHost);
		List<OssImageProcessParams> opps = works.stream()
		.sorted(Comparator.comparing(OssImageWork::showSorter))
		.map(work->work.mapperProcessParams(fn)).collect(Collectors.toList());
		return OssImageProcessParams.applyMultiParams(url, opps);
	}

	@Deprecated
	public static OssWorkProcess createExmaple() {
		return createExample();
	}
	public static OssWorkProcess createExample() {
		OssWorkProcess process = OssWorkProcess.create()
				.addWorks(ImageMarkOssImageWork.createExamples().toArray(new ImageMarkOssImageWork[]{}))
				.addWorks(TextMarkOssImageWork.createExamples().toArray(new TextMarkOssImageWork[]{}))
				.addWorks(OffsetCropModifyOssImageWork.createExamples().toArray(new OffsetCropModifyOssImageWork[]{}))
				.addWorks(LimitResizeModifyOssImageWork.createExamples().toArray(new LimitResizeModifyOssImageWork[]{}))
				.addWorks(RoundedCornersModifyOssImageWork.createExamples().toArray(new RoundedCornersModifyOssImageWork[]{}))
				.addWorks(CircleByRadiusOssImageWork.createExamples().toArray(new CircleByRadiusOssImageWork[]{}))
				.addWorks(CircleByRoundedCornersOssImageWork.createExamples().toArray(new CircleByRoundedCornersOssImageWork[]{}))
				;
		return process;
	}


	@Override
	public List<PhotoBodilyFormType> showFrameSchemes() {
		return sureHaveWorks().stream().map(HaveMarkPhotoFrame::mapperClassTypeMatch)
		.filter(Optional::isPresent).map(Optional::get)
		.map(HaveMarkPhotoFrame::showNonNullFrameSchemes)
		.reduce(new ArrayList<>(), (l1,l2)->{l1.addAll(l2);return l1;});
	}

}
