package com.mini.framework.util.oss.bean.work.modify;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

import com.mini.framework.util.bean.desc.Desc;
import com.mini.framework.util.oss.bean.OssImageProcessParams;
import com.mini.framework.util.oss.bean.work.type.OriginType;

/**
 * 裁剪 https://help.aliyun.com/document_detail/44693.html?spm=a2c4g.11186623.6.1240.1d75c1f6l9LavF
 * 
 * @author jayheo
 *
 */
@Desc("图片裁剪 https://help.aliyun.com/document_detail/44693.html?spm=a2c4g.11186623.6.1240.1d75c1f6l9LavF")
public class OffsetCropModifyOssImageWork extends ModifyOssImageWork {

	/**
	 * <pre>
	 * g	设置裁剪的原点位置，由九宫格的格式，一共有九个地方可以设置，每个位置位于每个九宫格的左上角	[nw, north, ne, west, center, east, sw, south, se]
	 * </pre>
	 */
	@Desc("位置参考依据")
	private OriginType origin;

	/**
	 * <pre>
	 * y	指定裁剪起点纵坐标（默认左上角为原点）	[0-图片边界]
	 * </pre>
	 */
	@Desc("指定裁剪起点纵坐标（默认左上角为原点）")
	private Integer yoffset;

	/**
	 * <pre>
	 * x	指定裁剪起点横坐标（默认左上角为原点）	[0-图片边界]
	 * </pre>
	 */
	@Desc("	指定裁剪起点横坐标（默认左上角为原点）")
	private Integer xoffset;

	@Desc("指定裁剪宽度 [0-图片宽度]")
	private Integer width;
	@Desc("指定裁剪高度 [0-图片高度]")
	private Integer height;

	public OriginType getOrigin() {
		return origin;
	}

	public void setOrigin(OriginType origin) {
		this.origin = origin;
	}

	public Integer getYoffset() {
		return yoffset;
	}

	public void setYoffset(Integer yoffset) {
		this.yoffset = yoffset;
	}

	public Integer getXoffset() {
		return xoffset;
	}

	public void setXoffset(Integer xoffset) {
		this.xoffset = xoffset;
	}

	public Integer getWidth() {
		return width;
	}

	public void setWidth(Integer width) {
		this.width = width;
	}

	public Integer getHeight() {
		return height;
	}

	public void setHeight(Integer height) {
		this.height = height;
	}

	@Override
	public OssImageProcessParams mapperProcessParams(Function<String, String> sureSameBucket) {
		return new OssImageProcessParams(getOssAction()).paramXyIfVal(xoffset, yoffset).paramWhIfVal(width, height)
				.paramIfVal("g", origin == null ? null : origin.toString());
	}

	public static List<OffsetCropModifyOssImageWork> createExamples() {
		OffsetCropModifyOssImageWork example = new OffsetCropModifyOssImageWork();
		example.setWorkDesc("图片裁剪 https://help.aliyun.com/document_detail/44693.html?spm=a2c4g.11186623.6.1240.1d75c1f6l9LavF");
		List<OffsetCropModifyOssImageWork> examples = new ArrayList<>();
		examples.add(example);
		return examples ;
	}
	

}
