package com.mini.framework.util.paas;

import com.mini.framework.core.exception.LogicException;
import com.mini.framework.core.status.Status;

import java.util.Optional;

/**
 * siteId获取器，能得到当前siteId
 * 
 * @author jayheo
 *
 * @param <S>
 */
public interface SiteIdReader<S> {
	/**
	 * 得到当前siteId
	 * 
	 * @return
	 */
	default S currSiteId(){
		return queryCurrSiteId().orElseThrow(()->new LogicException(Status.Logic.def, "没有找到商家信息"));
	}


	Optional<S> queryCurrSiteId();
}
