package com.mini.framework.util.report.statistics.summation.bean.compare;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.report.statistics.protocol.DivideDenominatorNumeratorSummation;
import com.mini.framework.util.report.statistics.protocol.OneStatisticsResult;
import com.mini.framework.util.report.statistics.protocol.StatisticsResultMeta;
import com.mini.framework.util.report.statistics.protocol.process.ForkQueryProcess;
import com.mini.framework.util.report.statistics.summation.bean.NativeRegionChildrenRegionSummationLine;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.List;
import java.util.Optional;


/**
 * TODO 还可以衍生出累计数据。例如 分布数据 12345 可以衍生出  1 3 6 10 15 的累计数据。
 */
public class NativeRegionChildrenRegionSummationLineCompare implements OneStatisticsResult, DivideDenominatorNumeratorSummation<NativeRegionChildrenRegionSummationLineCompare> {

    private StatisticsResultMeta resultMeta;

    /**
     * 进展
     */
    private ForkQueryProcess process;

    NativeRegionChildrenRegionSummationLine mainRegionLine;

    List<NativeRegionChildrenRegionSummationLine> contrastRegionLines;


    /**
     * 除以另外一个数
     * @param expand
     * @param numeratorSum 分子是不是使用sum
     * @param denominatorSum 分母是不是使用sum
     * @param other
     */
    @Override
    public void mapperAmountDivideByOther(long expand, boolean numeratorSum, boolean denominatorSum , NativeRegionChildrenRegionSummationLineCompare other){
        mainRegionLine.mapperAmountDivideByOther(expand,numeratorSum,denominatorSum,other.mainRegionLine);

        AssertUtil.assertNotFatalBug(contrastRegionLines.size()==other.contrastRegionLines.size()
                ,"contrastRegionLines.size():[%s]与other.contrastRegionLines.size():[%s]不一致",contrastRegionLines.size(),other.contrastRegionLines.size());

        this.mergeOtherResultMeta(other);

        mainRegionLine.mapperAmountDivideByOther(expand,numeratorSum,denominatorSum,other.mainRegionLine);
        for (int mainRegionLineIndex = 0; mainRegionLineIndex < contrastRegionLines.size(); mainRegionLineIndex++) {
            contrastRegionLines.get(mainRegionLineIndex).mapperAmountDivideByOther(expand,numeratorSum,denominatorSum,other.contrastRegionLines.get(mainRegionLineIndex));
        }

    }

    /**
     * 依次累计起来。得到一个累计的数据
     * @return
     */
    public NativeRegionChildrenRegionSummationLineCompare fillArraySequenceAccumulates(){
        mainRegionLine.fillArraySequenceAccumulates();
        contrastRegionLines.forEach(NativeRegionChildrenRegionSummationLine::fillArraySequenceAccumulates);
        return this;
    }

    public static NativeRegionChildrenRegionSummationLineCompare create(
            NativeRegionChildrenRegionSummationLine mainRegionLine, List<NativeRegionChildrenRegionSummationLine> contrastRegionLines) {
        NativeRegionChildrenRegionSummationLineCompare instance = new NativeRegionChildrenRegionSummationLineCompare();
        instance.mainRegionLine = mainRegionLine;
        instance.contrastRegionLines = contrastRegionLines;
        return instance;
    }


    public NativeRegionChildrenRegionSummationLine getMainRegionLine() {
        return mainRegionLine;
    }

    public void setMainRegionLine(NativeRegionChildrenRegionSummationLine mainRegionLine) {
        this.mainRegionLine = mainRegionLine;
    }

    public List<NativeRegionChildrenRegionSummationLine> getContrastRegionLines() {
        return contrastRegionLines;
    }

    public void setContrastRegionLines(List<NativeRegionChildrenRegionSummationLine> contrastRegionLines) {
        this.contrastRegionLines = contrastRegionLines;
    }

    public StatisticsResultMeta getResultMeta() {
        return resultMeta;
    }

    public void setResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    public ForkQueryProcess getProcess() {
        return process;
    }

    public void setProcess(ForkQueryProcess process) {
        this.process = process;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public void clearRedundancyFields() {
        if(contrastRegionLines!=null){
            contrastRegionLines.forEach(OneStatisticsResult::clearRedundancyFields);
        }
        if(mainRegionLine!=null){
            mainRegionLine.clearRedundancyFields();
        }
    }

    @Override
    public Optional<ForkQueryProcess> showQueryProcess() {
        return Optional.ofNullable(process);
    }

    @Override
    public void fillQueryProcess(ForkQueryProcess process) {
        this.process = process;
    }

    @Override
    public Optional<StatisticsResultMeta> showResultMeta() {
        return Optional.ofNullable(resultMeta);
    }

    @Override
    public void fillResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }
}
