package com.mini.framework.util.sql.view.bean;

import com.github.pagehelper.Page;
import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.exception.standard.CustomExceptionSupplier;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.page.SectionUtil;
import com.mini.framework.util.sql.view.able.ObjectValueReader;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 列表的定义
 * @author jayheo
 */
public class TableDefine extends SqlViewBean{


    private List<ColumnDefine> columns;

    /**
     * 解析mapList
     * @param mapList
     * @return
     */
    public <T> TableValue resolve(List<Map<String,T>> mapList){
        TableValue tableValue = TableValue.create(columns);
        Optional<Page<?>> page = SectionUtil.findPageFromList(mapList);
        mapList.stream()
                .map(ObjectValueReader::create)
                .forEach(tableValue::addRow);
        // 解析分页的结果
        tableValue.fillFromPage(page);
        return tableValue;
    }


    public <E extends CustomException> TableDefine validateComplete(CustomExceptionSupplier<E> exceptionSupplier){
        exceptionSupplier.applyAssert(columns!=null,"属性columns不能为空");
        columns.forEach(column -> column.validateComplete(exceptionSupplier.becauseFrom(columnError->String.format("table中有一列错误:%s",columnError))));
        return this;
    }



    public TableDefine addColumnDefine(ColumnDefine columnDefine){
        if(columns==null){
            columns = new ArrayList<>();
        }
        columns.add(columnDefine);
        return this;
    }

    /**
     * 如果有异常就走 参数中提供的异常。
     * @param json
     * @param exceptionSupplier
     * @return
     */
    public static <E extends CustomException> TableDefine fromJson(String json, CustomExceptionSupplier<E> exceptionSupplier){
        AssertUtil.assertMethodRequire(json,"json");
        //TODO 请参考这个检查一下其他的bean有没有要修改的。
        try{
            return fromJson(json,TableDefine.class);
        }catch (Exception e){
            //TODO 这个e里面的东西要处理，以后务必要优化一下 ，现在把异常栈丢弃了。应该优化 CustomExceptionSupplier 使用它能追加异常链
            throw exceptionSupplier.supply("json无法解析成TableDefine,出现错误%s",e.getMessage());
        }
    }


    public static TableDefine fromJson(String json){
        return fromJson(json,TableDefine.class);
    }

    public List<ColumnDefine> getColumns() {
        return columns;
    }

    public TableDefine setColumns(List<ColumnDefine> columns) {
        this.columns = columns;
        return this;
    }

}
