package com.mini.framework.util.sql.view.bean;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author jayheo
 */
public class TableOrigin extends SqlViewBean{

    private List<RowOrigin> rows;

    private Object origin;


    /**
     * 从listmap中得到table的原始数据。
     * @param mapList
     * @param <T>
     * @return
     */
    public static <T> TableOrigin from(List<Map<String,T>> mapList){
        TableOrigin instance = new TableOrigin();
        instance.origin = mapList;
        instance.rows = mapList.stream().map(RowOrigin::from).collect(Collectors.toList());
        return instance;
    }


    public Object getOrigin() {
        return origin;
    }

    public TableOrigin setOrigin(Object origin) {
        this.origin = origin;
        return this;
    }

    public List<RowOrigin> getRows() {
        return rows;
    }

    public TableOrigin setRows(List<RowOrigin> rows) {
        this.rows = rows;
        return this;
    }
}
