package com.mini.framework.util.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;







import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

import com.mini.framework.core.exception.HandleIOException;

/**
 * 这个类是测试使用的
 * @author jayheo
 *
 */
public class TestResourseUtil {
	
	private static final String utf8 = "utf-8";
	

	public static String readResAll(String dir,String name){
		return String.join("\n",readResLines(dir, name));
	}

	public static List<String> readResLines(String dir,String name){
		return readResLines(dir, name, utf8);
	}
	
	/**
	 * 从class目录的某个文件中读内容
	 * @param dir
	 * @param name
	 * @param charset
	 * @return
	 */
	public static List<String> readResLines(String dir,String name,String charset){
		InputStream is = TestResourseUtil.class.getResourceAsStream("/" + dir + "/" + name);
		try {
			List<String> lines = IOUtils.readLines(is, charset);
			return lines;
		} catch (IOException e) {
			throw new HandleIOException(e,"读资源文件时出错dir:%s,name:%s",dir,name);
		}
	}

	public static void writeResAll(String data, String dir, String name) {
		writeResAll(data, dir, name, utf8);
	}
	
	public static void writeResAll(String data, String dir, String name,String charset) {
		try {
			FileUtils.write(new File(dir,name), data, charset);
		} catch (IOException e) {
			throw new HandleIOException(e,"写资源文件时出错dir:%s,name:%s",dir,name);
		}
	}
	

	public static void writeResLines(List<String> lines,String dir,String name){
	}
}
