package com.mini.framework.util;

import org.apache.commons.lang3.ArrayUtils;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.core.exception.HandleEnDeCodeException;
import com.mini.framework.core.status.Status;

/**
 * 唯一编码映射util
 * @author jayheo
 * 这个类已被重构，需要使用 com.mini.framework.util.code.UnionCodeUtil
 */
@Deprecated 
public class UnionCodeUtil {
	public final static String codes = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
	private int length;

	/**
	 * @param length 必须指定原码算法长度
	 */
	public UnionCodeUtil(int length){
		this.length = length;
	}
	
	/**
	 * 解码<br>
	 * 把字符串解码成整形数组<br>
	 * @param codeList
	 * @return
	 */
	public int[] decode(String codeList){
		AssertUtil.simpleAssertByStatus(codeList!=null, Status.Logic.def, "union不能为空");
		long lon = 0;
		
		for (int i = 0; i < codeList.length(); i++) {
			lon*=codes.length();
			char code = codeList.charAt(i);
			int val = codes.indexOf(code);
			AssertUtil.simpleAssertByStatus(val>=0,Status.Handle.enDeCode,"[%s]不是一个合法的unionCode",codeList);
			lon += val;
		}
		
		String str = String.valueOf(lon);
		int strLen = str.length();
		
		int[] sourses = new int[length];
		
		int offset = 1;
		
		try{
			for (int i = 0; i < sourses.length; i++) {
				int len = str.charAt(strLen-length+i)-48 + 1;
				sourses[i] = Integer.parseInt(str.substring(offset, offset + len));
				offset+=len;
			}
		}catch(ArrayIndexOutOfBoundsException e){
			throw new HandleEnDeCodeException(e,"[%s]不是一个合法的unionCode",codeList);
		}
		viledateFormat(sourses);
		ArrayUtils.reverse(sourses);
		return sourses;
	}
	
	private void viledateFormat(int... sourses){
		AssertUtil.simpleAssertByStatus(
				sourses.length==length,Status.Handle.enDeCode,"参数长度必须为%s位",length);
		
		for (int sourse : sourses) {
			AssertUtil.simpleAssertByStatus(
					sourse > 0,Status.Handle.enDeCode,"sourse[%s]必须大于0",sourse);
		}
	}
	
	/**
	 * 编码<br>
	 * 把整形数组编码成字符串<br>
	 * @param sourse 编码因子<br>
	 * @return
	 */
	public String encode(int... sourses) {
		viledateFormat(sourses);
		//返回转顺序
		ArrayUtils.reverse(sourses);
		//结尾部分
		String suffix = "";
		//中间部分
		String midfix = "";
		//总和
		int sum = 0;
		for (int sourse : sourses) {
			suffix += length(sourse) - 1;
			midfix += sourse;
			sum += sourse;
		}

		String longChar = (sum%9+1) + midfix  + suffix;
		long lon = Long.parseLong(longChar);
		String code = "";
		 while (lon > 0){
			long yu = lon % codes.length();
			lon /= codes.length();
			code = codes.charAt((int) yu)  + code;
		 }
		return code;
	}

	public static int length(int sourse) {
		return String.valueOf(sourse).toString().length();
	}
}
