package com.mini.framework.util.date;

import java.util.Date;

import org.apache.commons.lang3.time.DateUtils;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.core.status.Status;

/**
 * 这里表示某一时/天/周/月/年
 * 
 * @author 时间段
 *
 */
public class TimeSection {

	private TimeSectionType timeUnit;

	private Date sectionPoint;
	
	public TimeSection(TimeSectionType timeUnit, Date sectionPoint) {
		super();
		this.timeUnit = timeUnit;
		this.sectionPoint = sectionPoint;
		this.validate();
	}

	public TimeSectionType getTimeUnit() {
		return timeUnit;
	}

	public void setTimeUnit(TimeSectionType timeUnit) {
		this.timeUnit = timeUnit;
	}

	public Date getSectionPoint() {
		return sectionPoint;
	}

	public void setSectionPoint(Date sectionPoint) {
		this.sectionPoint = sectionPoint;
	}
	
	public void validate(){
		AssertUtil.assertNoBadReq(timeUnit!=null, Status.BadReq.illParam, "不能没有时间单元timeUnit" );
		AssertUtil.assertNoBadReq(sectionPoint!=null, Status.BadReq.illParam, "不能没有时间起点" );
		boolean vali = DateUtil.isDateUnitPoint(timeUnit, sectionPoint);
		AssertUtil.assertNoBadReq(vali, Status.BadReq.illParam, "时间:[%s]必须为%s的起点", sectionPoint,timeUnit);
		
	}
	
	
	public static TimeSection createTimeSection(Date date,TimeSectionType timeSectionType){
		Date sectionPoint = DateUtil.getCleanedDateUnit(timeSectionType, date);
		return new TimeSection(timeSectionType, sectionPoint);
	}
	
	public Date countEndDatePoint(){
		validate();
		if(TimeSectionType.all.equals( timeUnit)){
			//TODO 统一定到结束时间是 3000年
			return  DateUtils.addYears(sectionPoint,1000);
		}
		return DateUtil.addTimeUnit(timeUnit, sectionPoint, 1);
	}

}