package com.mini.framework.util.generic.define;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * set集合 这种写法是解决泛型带来的部分参数不明确的影响<BR>
 * @param <B>
 */
public class SetBean<B> {


    /**
     * 初始值，不可以被修改的。
     */
    private final Set<B> value;


    private SetBean(Set<B> value) {
        this.value = value;
    }


    public static <B> SetBean<B> of(Collection<B> coll){
        HashSet<B> beans = new HashSet<>(coll);
        return new SetBean<>(beans);
    }
    public static <I,B> SetBean<B> of(Function<I,B> beanGetter,Collection<I> coll){
        Set<B> beans = coll.stream().map(beanGetter).collect(Collectors.toSet());
        return new SetBean<>(beans);
    }


    public static <B> SetBean<B> of(B ...beans){
        //对于可能为空的 应该使用方法 ofNullable
        Objects.requireNonNull(beans,"beans 不能为空");
        Set<B> set = new HashSet<>(Arrays.asList(beans));
        return new SetBean<>(set);
    }


    public static <B> SetBean<B> ofNullable(B[] beansNullable){
        if(beansNullable == null){
            return new SetBean<>(new HashSet<>());
        }else{
            return of(beansNullable);
        }
    }

    public <O> SetBean<O> map(Function<B,O> mapper){
        Set<O> collect = value.stream().map(mapper).collect(Collectors.toSet());
        return new SetBean<>(collect);
    }

    public Set<B> out(){
        return new HashSet<>(value);
    }


    public boolean isEmpty(){
        return value == null || value.isEmpty();
    }

    public boolean isNotEmpty(){
        return !isEmpty();
    }


    public boolean ifEmpty(Consumer<Set<B>> consumer){
        if(isEmpty()){
            consumer.accept(value);
            return true;
        }else{
            return false;
        }
    }



}
