package com.mini.framework.util.log.trace;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 链路触发点<br>
 * 用于标记一个线程的起点方便把整个线程串起来<br>
 * @author zhxie
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface TraceTrigger {
	/**
	 * 用简短的文字描述这个方法是做什么用的
	 * @return
	 */
	String value() default "请用简短的文字描述这个方法是做什么用的";
}
