package com.mini.framework.util.oss.bean.work;

import java.lang.reflect.Type;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mini.framework.util.oss.bean.work.type.WorkActionType;

/**
 * oss图片处理工作的解析器
 * @author jayheo
 */
public class OssImageWorkDeserializer implements JsonDeserializer<OssImageWork> {

	@Override
	public OssImageWork deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
			throws JsonParseException {
		JsonObject jsonObject = json.getAsJsonObject();
		JsonElement bizJsonElement = jsonObject.get(WorkActionType.typeKey);
		if(bizJsonElement == null){
			throw new JsonParseException(String.format("json片段中中应该包含key:[%s],json片段:[%s]",WorkActionType.typeKey,json));
		}else{
			String typeStr = bizJsonElement.getAsString();
			WorkActionType type = WorkActionType.parse(typeStr);
			Class<? extends OssImageWork> clazz = type.work();
			return context.deserialize(json, clazz);
		}
	}
}