package com.mini.framework.util.report.statistics;


import com.mini.framework.util.report.statistics.protocol.process.ForkQueryProcess;
import com.mini.framework.util.report.statistics.protocol.process.ProcessContext;

import java.util.Optional;
import java.util.concurrent.ThreadFactory;

/**
 * 分散查询过程的
 */
public interface ForkQueryable {


    /**
     * 能接受的批量查询的线程
     * @return
     */
    Optional<Integer> acceptForkQueryThreadSize();


    /**
     * 纯程工场地
     * @return
     */
    ThreadFactory threadFactoryOfForkQuery();

    /**
     * 创建一个查询过程的上下文
     * @return
     */
    default ProcessContext createQueryProcessContext(){
        ForkQueryProcess process = ForkQueryProcess.create(acceptForkQueryThreadSize(),threadFactoryOfForkQuery());
        ProcessContext context = new ProcessContext();
        context.setProcess(process);
        return context;
    }
}
