package com.mini.framework.util.report.statistics.ranking;

import com.mini.framework.util.date.DateRange;
import com.mini.framework.util.report.statistics.Statistics;
import com.mini.framework.util.report.statistics.protocol.StatisticsSerializeParams;
import com.mini.framework.util.report.statistics.protocol.TimeRegionRange;
import com.mini.framework.util.report.statistics.protocol.TimeRegionUnit;
import com.mini.framework.util.report.statistics.protocol.process.ProcessContext;
import com.mini.framework.util.report.statistics.ranking.bean.RankingElementSummationAmount;
import com.mini.framework.util.report.statistics.ranking.bean.StatisticsRankingTable;

import java.util.Date;

public interface RankingStatistics<P extends StatisticsSerializeParams,E extends RankingElementSummationAmount<E>>
        extends Statistics {


    /**
     * 统计自然时间的排行榜
     * @param context 查询过程的上下文
     * @param params
     * @param regionRange
     * @param topSize
     * @param queryLimitDate
     * @return
     */
    StatisticsRankingTable<E> statisticsNativeDateRanking(ProcessContext context,P params, TimeRegionRange regionRange, int topSize, Date queryLimitDate) ;


    /**
     * 统计多个自然时间序列的排行榜
     * @param context 查询过程的上下文
     * @param params
     * @param regionUnit
     * @param scopeRange
     * @param topSize
     * @param queryLimitDate
     * @return
     */
    StatisticsRankingTable<E> statisticsNativeDateArrayRanking(ProcessContext context,P params, TimeRegionUnit regionUnit, DateRange scopeRange, int topSize, Date queryLimitDate);


    /**
     * 统计自定义(指定的)时间范围的排行榜
     * @param context 查询过程的上下文
     * @param params
     * @param dateRange
     * @param topSize
     * @param queryLimitDate
     * @return
     */
    StatisticsRankingTable<E> statisticsCustomDateRangeRanking(ProcessContext context, P params, DateRange dateRange, int topSize, Date queryLimitDate);






}
