package com.mini.framework.util.type;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * @author jayheo
 */
public interface EnumSupport<E extends EnumSupport<E>> {

	/**
	 * 显示枚举的名字。但是要注意，如果枚举重写了toString会有bug
	 * @return
	 */
	default String showName(){
		return showValue().toString().toString();
	}

	/**
	 * 显示当前的枚举类
	 * @return
	 */
	default E showValue(){
		return showValues().stream().filter(Predicate.isEqual(this)).findFirst().get();
	}

	/**
	 * 显示所有的类
	 * @return
	 */
	default List<E> showValues(){
		AssertUtil.assertSupport(this.ifSuperEnum(), "接口%s只允许被enum实现不允许被%s实现",EnumSupport.class.getName(),this.getClass().getName());
		return Stream.of(findClassAnonymousCompatible(this.getClass()).getEnumConstants()).map(e->(E)e).collect(Collectors.toList());
	}


	/**
	 * 找到类，并兼容匿名类的写法
	 * @param clazz
	 * @return
	 */
	static Class<?> findClassAnonymousCompatible(Class<?> clazz){
		if(clazz.isAnonymousClass()){
			return clazz.getSuperclass();
		}else{
			return clazz;
		}
	}


	/**
	 * 是不是最终继承了枚举类。
	 * 对于类型 TimeUnit那种 重写了方法的枚举他实际不是一个枚举，而是一个子类了
	 * @return
	 */
	default boolean ifSuperEnum(){
		return findClassAnonymousCompatible(this.getClass()).isEnum();
	}

	/**
	 * 与另外一个类型相等
	 * @param other
	 * @return
	 * */
	default boolean equalType(E other){
		return equalName(other.showName());
	}


	/**
	 * 名字是不是相同
	 * @param otherName
	 * @return
	 */
	default boolean equalName(String otherName){
		return showName().equals(otherName);
	}


	/**
	 * 与另外几个类型中的任何一个相等
	 * @param others
	 * @return
	 */
	default boolean equalAnyType(E... others){
		return Stream.of(others).anyMatch(this::equalType);
	}

}
