/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.access;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.access.AccessTokenResp;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.RegexUtil;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class SimpleAccessBean {
    private String accessKey;
    private String accessToken;
    private Date expireDate;
    private String[] params;

    public SimpleAccessBean(String accessKey, String accessToken, Date expireDate, String[] params) {
        this.accessKey = accessKey;
        this.accessToken = accessToken;
        this.expireDate = expireDate;
        this.params = params;
    }

    public SimpleAccessBean() {
    }

    public SimpleAccessBean(String token) {
        AssertUtil.assertMethodRequire(token, "token");
        AssertUtil.assertNoBadReq(token.length() > 30, Status.BadReq.illParam, "accessToken:[%s]\u957f\u5ea6\u81f3\u5c1130\u4f4d\u4ee5\u4e0a", token);
        String[] items = RegexUtil.getMatch("([^-]+)-([^-]+)-(\\d+)", token, 1, 2, 3);
        AssertUtil.assertNoBadReq(items != null, Status.BadReq.illParam, "accessToken:[%s]\u683c\u5f0f\u9519\u8bef", token);
        this.accessKey = items[0];
        this.accessToken = items[1];
        this.expireDate = new Date(Long.parseLong(items[2]));
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    public String[] getParams() {
        return this.params;
    }

    public void setParams(String[] params) {
        this.params = params;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public AccessTokenResp showTokenBean() {
        return new AccessTokenResp(this.showToken(), this.params);
    }

    public String showToken() {
        AssertUtil.assertSupport(this.accessKey != null, "accessKey\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        AssertUtil.assertSupport(this.accessToken != null, "accessToken\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        AssertUtil.assertSupport(this.expireDate != null, "expireDate\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        return String.format("%s-%s-%s", this.accessKey, this.accessToken, this.expireDate.getTime());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

